/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.ide.common.rendering.api.RenderSession;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionEvent;
import com.android.tools.idea.common.surface.KeyPressedEvent;
import com.android.tools.idea.common.surface.KeyReleasedEvent;
import com.android.tools.idea.common.surface.MouseDraggedEvent;
import com.android.tools.idea.common.surface.MousePressedEvent;
import com.android.tools.idea.common.surface.MouseReleasedEvent;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\r\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u000f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u0012\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/common/surface/LayoutlibInteraction;", "Lcom/android/tools/idea/common/surface/Interaction;", "sceneView", "Lcom/android/tools/idea/common/surface/SceneView;", "(Lcom/android/tools/idea/common/surface/SceneView;)V", "begin", "", "event", "Lcom/android/tools/idea/common/surface/InteractionEvent;", "x", "", "y", "modifiersEx", "cancel", "commit", "end", "getCursor", "Ljava/awt/Cursor;", "update", "intellij.android.designer"})
public final class LayoutlibInteraction
extends Interaction {
    @NotNull
    private final SceneView sceneView;

    public LayoutlibInteraction(@NotNull SceneView sceneView) {
        Intrinsics.checkNotNullParameter((Object)sceneView, (String)"sceneView");
        this.sceneView = sceneView;
    }

    @Override
    public void commit(@NotNull InteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MouseReleasedEvent mouseEvent = (MouseReleasedEvent)event;
        this.end(((MouseEvent)mouseEvent.getEventObject()).getX(), ((MouseEvent)mouseEvent.getEventObject()).getY(), ((MouseEvent)mouseEvent.getEventObject()).getModifiersEx());
    }

    @Override
    public void end(int x, int y, int modifiersEx) {
        int androidX = Coordinates.getAndroidX(this.sceneView, x);
        int androidY = Coordinates.getAndroidY(this.sceneView, y);
        SceneManager sceneManager = this.sceneView.getSceneManager();
        Intrinsics.checkNotNullExpressionValue((Object)sceneManager, (String)"sceneView.sceneManager");
        SceneManager sceneManager2 = sceneManager;
        if (sceneManager2 instanceof LayoutlibSceneManager) {
            ((LayoutlibSceneManager)sceneManager2).triggerTouchEventAsync(RenderSession.TouchEventType.RELEASE, androidX, androidY);
        }
        this.sceneView.getSurface().repaint();
    }

    @Override
    public void begin(@NotNull InteractionEvent event) {
        block2: {
            InteractionEvent interactionEvent;
            block1: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                interactionEvent = event;
                if (!(interactionEvent instanceof MousePressedEvent)) break block1;
                this.begin(((MouseEvent)((MousePressedEvent)event).getEventObject()).getX(), ((MouseEvent)((MousePressedEvent)event).getEventObject()).getY(), ((MouseEvent)((MousePressedEvent)event).getEventObject()).getModifiersEx());
                break block2;
            }
            if (!(interactionEvent instanceof KeyPressedEvent)) break block2;
            SceneManager sceneManager = this.sceneView.getSceneManager();
            LayoutlibSceneManager layoutlibSceneManager = sceneManager instanceof LayoutlibSceneManager ? (LayoutlibSceneManager)sceneManager : null;
            if (layoutlibSceneManager != null) {
                layoutlibSceneManager.triggerKeyEventAsync((KeyEvent)((KeyPressedEvent)event).getEventObject());
            }
        }
    }

    @Override
    public void begin(int x, int y, int modifiersEx) {
        super.begin(x, y, modifiersEx);
        int androidX = Coordinates.getAndroidX(this.sceneView, this.myStartX);
        int androidY = Coordinates.getAndroidY(this.sceneView, this.myStartY);
        SceneManager sceneManager = this.sceneView.getSceneManager();
        Intrinsics.checkNotNullExpressionValue((Object)sceneManager, (String)"sceneView.sceneManager");
        SceneManager sceneManager2 = sceneManager;
        if (sceneManager2 instanceof LayoutlibSceneManager) {
            ((LayoutlibSceneManager)sceneManager2).triggerTouchEventAsync(RenderSession.TouchEventType.PRESS, androidX, androidY);
        }
    }

    @Override
    public void cancel(@NotNull InteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.cancel(event.getInfo().getX(), event.getInfo().getY(), event.getInfo().getModifiersEx());
    }

    @Override
    public void cancel(int x, int y, int modifiersEx) {
        this.sceneView.getScene().mouseCancel();
        this.sceneView.getSurface().repaint();
    }

    @Override
    @Nullable
    public Cursor getCursor() {
        return this.sceneView.getScene().getMouseCursor();
    }

    @Override
    public void update(@NotNull InteractionEvent event) {
        block2: {
            InteractionEvent interactionEvent;
            block3: {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    interactionEvent = event;
                    if (!(interactionEvent instanceof MouseDraggedEvent)) break block1;
                    int mouseX = ((MouseEvent)((MouseDraggedEvent)event).getEventObject()).getX();
                    int mouseY = ((MouseEvent)((MouseDraggedEvent)event).getEventObject()).getY();
                    this.sceneView.getContext().setMouseLocation(mouseX, mouseY);
                    this.update(mouseX, mouseY, ((MouseEvent)((MouseDraggedEvent)event).getEventObject()).getModifiersEx());
                    break block2;
                }
                if (!(interactionEvent instanceof KeyPressedEvent)) break block3;
                SceneManager sceneManager = this.sceneView.getSceneManager();
                LayoutlibSceneManager layoutlibSceneManager = sceneManager instanceof LayoutlibSceneManager ? (LayoutlibSceneManager)sceneManager : null;
                if (layoutlibSceneManager == null) break block2;
                layoutlibSceneManager.triggerKeyEventAsync((KeyEvent)((KeyPressedEvent)event).getEventObject());
                break block2;
            }
            if (!(interactionEvent instanceof KeyReleasedEvent)) break block2;
            SceneManager sceneManager = this.sceneView.getSceneManager();
            LayoutlibSceneManager layoutlibSceneManager = sceneManager instanceof LayoutlibSceneManager ? (LayoutlibSceneManager)sceneManager : null;
            if (layoutlibSceneManager != null) {
                layoutlibSceneManager.triggerKeyEventAsync((KeyEvent)((KeyReleasedEvent)event).getEventObject());
            }
        }
    }

    @Override
    public void update(int x, int y, int modifiersEx) {
        super.update(x, y, modifiersEx);
        int androidX = Coordinates.getAndroidX(this.sceneView, x);
        int androidY = Coordinates.getAndroidY(this.sceneView, y);
        SceneManager sceneManager = this.sceneView.getSceneManager();
        Intrinsics.checkNotNullExpressionValue((Object)sceneManager, (String)"sceneView.sceneManager");
        SceneManager sceneManager2 = sceneManager;
        if (sceneManager2 instanceof LayoutlibSceneManager) {
            ((LayoutlibSceneManager)sceneManager2).triggerTouchEventAsync(RenderSession.TouchEventType.DRAG, androidX, androidY);
        }
        this.sceneView.getSurface().repaint();
    }
}

