/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DrawCommand;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class DrawRegion
extends Rectangle
implements DrawCommand {
    public static boolean inside(int px, int py, int x, int y, int width2, int height2) {
        int w = width2;
        int h = height2;
        if ((w | h) < 0) {
            return false;
        }
        if (px < x || py < y) {
            return false;
        }
        h += y;
        return !((w += x) >= x && w <= px || h >= y && h <= py);
    }

    public static float distance(int mx, int my, int x, int y, int width2, int height2) {
        if (DrawRegion.inside(mx, my, x, y, width2, height2)) {
            return 0.0f;
        }
        if (mx > x && mx < x + width2) {
            return Math.min(Math.abs(my - y), Math.abs(my - (y + height2)));
        }
        if (my > y && my < y + height2) {
            return Math.min(Math.abs(mx - x), Math.abs(mx - (x + width2)));
        }
        if (mx <= x && my <= y) {
            float dx = mx - x;
            float dy = my - y;
            return (float)Math.hypot(dx, dy);
        }
        if (mx <= x && my >= y + height2) {
            float dx = mx - x;
            float dy = my - (y + height2);
            return (float)Math.hypot(dx, dy);
        }
        if (mx >= x + width2 && my <= y) {
            float dx = mx - (x + width2);
            float dy = my - y;
            return (float)Math.hypot(dx, dy);
        }
        if (mx >= x + width2 && my >= y + height2) {
            float dx = mx - (x + width2);
            float dy = my - (y + height2);
            return (float)Math.hypot(dx, dy);
        }
        return 0.0f;
    }

    @Override
    public String serialize() {
        return this.getClass().getSimpleName() + "," + this.x + "," + this.y + "," + this.width + "," + this.height;
    }

    public DrawRegion() {
    }

    @Override
    public int getLevel() {
        return 50;
    }

    public DrawRegion(String s) {
        String[] sp = s.split(",");
        this.parse(sp, 0);
    }

    protected int parse(String[] sp, int c) {
        this.x = Integer.parseInt(sp[c++]);
        this.y = Integer.parseInt(sp[c++]);
        this.width = Integer.parseInt(sp[c++]);
        this.height = Integer.parseInt(sp[c++]);
        return c;
    }

    public DrawRegion(int x, int y, int width2, int height2) {
        super(x, y, width2, height2);
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        g.drawRect(this.x, this.y, this.width, this.height);
    }
}

