/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import org.jetbrains.annotations.NotNull;

public class DrawNlComponentFrame
extends DrawRegion {
    private static final Stroke myHoveredStroke = new BasicStroke(2.0f);
    private static final Stroke myNormalStroke = new BasicStroke(1.0f);
    private static final Stroke myWrapStroke = new BasicStroke(1.0f);
    private static final Stroke myMatchParentStroke = new BasicStroke(1.0f);
    private static final Stroke myDragReceiverStroke = new BasicStroke(3.0f);
    private static final Stroke myMatchConstraintStroke = new BasicStroke(1.0f);
    @NotNull
    private SceneComponent.DrawState myMode;
    private int myLayoutWidth;
    private int myLayoutHeight;
    private int myLevel = 20;

    public DrawNlComponentFrame(String s) {
        String[] sp = s.split(",");
        int c = 0;
        c = super.parse(sp, c);
        this.myMode = SceneComponent.DrawState.values()[Integer.parseInt(sp[c++])];
        this.myLayoutWidth = Integer.parseInt(sp[c++]);
        this.myLayoutHeight = Integer.parseInt(sp[c++]);
    }

    @Override
    public int getLevel() {
        return this.myLevel;
    }

    public DrawNlComponentFrame(int x, int y, int width2, int height2, @NotNull SceneComponent.DrawState mode, int layout_width, int layout_height) {
        super(x, y, width2, height2);
        this.myMode = mode;
        this.myLayoutWidth = layout_width;
        this.myLayoutHeight = layout_height;
        if (mode == SceneComponent.DrawState.SELECTED) {
            this.myLevel = 30;
        }
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        ColorSet colorSet = sceneContext.getColorSet();
        Stroke previousStroke = g.getStroke();
        Color previousColor = g.getColor();
        g.setStroke(myNormalStroke);
        g.setColor(DrawNlComponentFrame.getFrameColor(colorSet, this.myMode));
        if (this.myMode == SceneComponent.DrawState.DRAG) {
            g.setStroke(myDragReceiverStroke);
            g.drawRect(this.x, this.y, this.width, this.height);
        } else {
            Shape clipping = g.getClip();
            if (clipping != null && !clipping.contains(this.x, this.y, this.x + this.width, this.x + this.height)) {
                g.setClip(sceneContext.getRenderableBounds());
                g.setStroke(ColorSet.sDashedStroke);
                g.drawLine(this.x, this.y, this.x, this.y + this.height);
                g.drawLine(this.x + this.width, this.y, this.x + this.width, this.y + this.height);
                g.drawLine(this.x, this.y, this.x + this.width, this.y);
                g.drawLine(this.x, this.y + this.height, this.x + this.width, this.y + this.height);
                g.setClip(clipping);
            }
            g.setStroke(DrawNlComponentFrame.getStroke(this.myLayoutHeight, this.myMode));
            g.drawLine(this.x, this.y, this.x, this.y + this.height);
            g.drawLine(this.x + this.width, this.y, this.x + this.width, this.y + this.height);
            g.setStroke(DrawNlComponentFrame.getStroke(this.myLayoutWidth, this.myMode));
            g.drawLine(this.x, this.y, this.x + this.width, this.y);
            g.drawLine(this.x, this.y + this.height, this.x + this.width, this.y + this.height);
        }
        g.setColor(previousColor);
        g.setStroke(previousStroke);
    }

    @NotNull
    private static Color getFrameColor(@NotNull ColorSet colorSet, @NotNull SceneComponent.DrawState mode) {
        switch (mode) {
            case SUBDUED: {
                return colorSet.getSubduedFrames();
            }
            case NORMAL: {
                return colorSet.getFrames();
            }
            case HOVER: {
                return colorSet.getHighlightedFrames();
            }
            case SELECTED: {
                return colorSet.getSelectedFrames();
            }
            case DRAG: {
                return colorSet.getDragReceiverFrames();
            }
        }
        return colorSet.getFrames();
    }

    @NotNull
    private static Stroke getStroke(int dim2, @NotNull SceneComponent.DrawState mode) {
        if (mode == SceneComponent.DrawState.HOVER) {
            return myHoveredStroke;
        }
        if (dim2 == 0) {
            return myMatchConstraintStroke;
        }
        if (dim2 == -1) {
            return myMatchParentStroke;
        }
        if (dim2 == -2) {
            return myWrapStroke;
        }
        return myNormalStroke;
    }

    @Override
    public String serialize() {
        return super.serialize() + "," + this.myMode.ordinal() + "," + this.myLayoutHeight + "," + this.myLayoutHeight;
    }

    public static void add(DisplayList list, SceneContext sceneContext, Rectangle rect, @NotNull SceneComponent.DrawState mode, int layout_width, int layout_height) {
        int l = sceneContext.getSwingXDip(rect.x);
        int t = sceneContext.getSwingYDip(rect.y);
        int w = sceneContext.getSwingDimensionDip(rect.width);
        int h = sceneContext.getSwingDimensionDip(rect.height);
        list.add(new DrawNlComponentFrame(l, t, w, h, mode, layout_width, layout_height));
    }
}

