/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawLassoUtil;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import java.awt.Graphics2D;

public class DrawLasso
extends DrawRegion {
    private int myMouseX;
    private int myMouseY;
    private boolean myShowSize;

    public DrawLasso(String s) {
        super(s);
    }

    public DrawLasso(int x, int y, int width2, int height2, int mouseX, int mouseY, boolean showSize) {
        super(x, y, width2, height2);
        this.myMouseX = mouseX;
        this.myMouseY = mouseY;
        this.myShowSize = showSize;
    }

    @Override
    protected int parse(String[] sp, int c) {
        this.myMouseX = Integer.parseInt(sp[c++]);
        this.myMouseY = Integer.parseInt(sp[c++]);
        this.myShowSize = Boolean.parseBoolean(sp[c++]);
        return c;
    }

    @Override
    public String serialize() {
        return super.serialize() + "," + this.myMouseX + "," + this.myMouseY + "," + this.myShowSize;
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        int dpWidth = (int)((double)sceneContext.pxToDp(this.width) / sceneContext.getScale());
        int dpHeight = (int)((double)sceneContext.pxToDp(this.height) / sceneContext.getScale());
        ColorSet colorSet = sceneContext.getColorSet();
        DrawLassoUtil.drawLasso(g, colorSet, this.x, this.y, this.width, this.height, this.myMouseX, this.myMouseY, dpWidth, dpHeight, this.myShowSize);
    }

    public static void add(DisplayList list, SceneContext transform, float left, float top, float right2, float bottom2, float mouseX, float mouseY, boolean showSize) {
        int l = transform.getSwingXDip(left);
        int t = transform.getSwingYDip(top);
        int w = transform.getSwingDimensionDip(right2 - left);
        int h = transform.getSwingDimensionDip(bottom2 - top);
        int swingMouseX = transform.getSwingXDip(mouseX);
        int swingMouseY = transform.getSwingYDip(mouseY);
        list.add(new DrawLasso(l, t, w, h, swingMouseX, swingMouseY, showSize));
    }
}

