/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.DefaultHitProvider;
import com.android.tools.idea.common.scene.DefaultSceneManagerHierarchyProvider;
import com.android.tools.idea.common.scene.HitProvider;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecoratorFactory;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderUtils;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SceneManager
implements Disposable,
ResourceNotificationManager.ResourceChangeListener {
    public static final boolean SUPPORTS_LOCKING = false;
    @NotNull
    private final NlModel myModel;
    @NotNull
    private final DesignSurface<?> myDesignSurface;
    @NotNull
    private final Scene myScene;
    @Nullable
    private SceneView mySceneView;
    @NotNull
    private final HitProvider myHitProvider = new DefaultHitProvider();
    @NotNull
    private final SceneComponentHierarchyProvider mySceneComponentProvider;
    @NotNull
    private final SceneUpdateListener mySceneUpdateListener;
    @NotNull
    private final Object myActivationLock = new Object();
    private boolean myIsActivated = false;

    public SceneManager(@NotNull NlModel model2, @NotNull DesignSurface<?> surface2, @Nullable SceneComponentHierarchyProvider sceneComponentProvider, @Nullable SceneUpdateListener sceneUpdateListener) {
        this.myModel = model2;
        this.myDesignSurface = surface2;
        Disposer.register((Disposable)model2, (Disposable)this);
        this.mySceneComponentProvider = sceneComponentProvider == null ? new DefaultSceneManagerHierarchyProvider() : sceneComponentProvider;
        this.mySceneUpdateListener = sceneUpdateListener == null ? new DefaultSceneUpdateListener() : sceneUpdateListener;
        this.myScene = new Scene(this, this.myDesignSurface);
    }

    protected void createSceneView() {
        if (this.mySceneView != null) {
            this.mySceneView.dispose();
        }
        this.mySceneView = this.doCreateSceneView();
    }

    @NotNull
    protected abstract SceneView doCreateSceneView();

    public final void updateSceneView() {
        this.createSceneView();
    }

    @Deprecated
    @NotNull
    public SceneView getSceneView() {
        assert (this.mySceneView != null) : "createSceneView was not called";
        return this.mySceneView;
    }

    @NotNull
    public List<SceneView> getSceneViews() {
        return ImmutableList.of((Object)this.getSceneView());
    }

    public abstract float getSceneScalingFactor();

    public void dispose() {
        this.deactivate(this);
        for (SceneView sceneView : this.getSceneViews()) {
            sceneView.dispose();
        }
    }

    public void update() {
        SceneComponent root;
        ImmutableList<NlComponent> components = this.getModel().getComponents();
        Scene scene = this.getScene();
        if (components.isEmpty()) {
            scene.removeAllComponents();
            scene.setRoot(null);
            return;
        }
        HashSet<SceneComponent> usedComponents = new HashSet<SceneComponent>();
        HashSet<SceneComponent> oldComponents = new HashSet<SceneComponent>(scene.getSceneComponents());
        NlComponent rootComponent = this.getRoot();
        if (this.myScene.getRoot() != null && rootComponent != this.myScene.getRoot().getNlComponent()) {
            scene.removeAllComponents();
            scene.setRoot(null);
        }
        this.mySceneUpdateListener.onUpdate(rootComponent, this.myDesignSurface);
        List<SceneComponent> hierarchy = this.mySceneComponentProvider.createHierarchy(this, rootComponent);
        if (hierarchy.isEmpty()) {
            root = null;
        } else if (hierarchy.size() == 1) {
            root = hierarchy.get(0);
        } else {
            root = new SceneComponent(scene, rootComponent, scene.getSceneManager().getHitProvider(rootComponent));
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxX = 0;
            int maxY = 0;
            for (SceneComponent child : hierarchy) {
                minX = Math.min(minX, child.getDrawX());
                minY = Math.min(minY, child.getDrawY());
                maxX = Math.max(maxX, child.getDrawX() + child.getDrawWidth());
                maxY = Math.max(maxY, child.getDrawY() + child.getDrawHeight());
                root.addChild(child);
            }
            root.setPosition(minX, minY);
            root.setSize(maxX - minX, maxY - minY);
        }
        scene.setRoot(root);
        if (root != null) {
            this.updateFromComponent(root, usedComponents);
        }
        oldComponents.removeAll(usedComponents);
        oldComponents.removeIf(component -> component instanceof TemporarySceneComponent);
        oldComponents.forEach(scene::removeComponent);
        scene.needsRebuildList();
    }

    @NotNull
    protected NlComponent getRoot() {
        return ((NlComponent)this.getModel().getComponents().get(0)).getRoot();
    }

    public static boolean isComponentLocked(@NotNull NlComponent component) {
        return false;
    }

    protected final void updateFromComponent(@NotNull SceneComponent component, @NotNull Set<SceneComponent> seenComponents) {
        seenComponents.add(component);
        this.syncFromNlComponent(component);
        for (SceneComponent child : component.getChildren()) {
            this.updateFromComponent(child, seenComponents);
        }
    }

    @NotNull
    public abstract TemporarySceneComponent createTemporaryComponent(@NotNull NlComponent var1);

    protected final void syncFromNlComponent(SceneComponent sceneComponent) {
        this.mySceneComponentProvider.syncFromNlComponent(sceneComponent);
    }

    @NotNull
    protected DesignSurface<?> getDesignSurface() {
        return this.myDesignSurface;
    }

    @NotNull
    public NlModel getModel() {
        return this.myModel;
    }

    @NotNull
    public Scene getScene() {
        return this.myScene;
    }

    @NotNull
    public abstract CompletableFuture<Void> requestRenderAsync();

    @NotNull
    public CompletableFuture<Void> requestLayoutAndRenderAsync(boolean animate) {
        return CompletableFuture.completedFuture(null);
    }

    @NotNull
    public abstract CompletableFuture<Void> requestLayoutAsync(boolean var1);

    public abstract void layout(boolean var1);

    @NotNull
    public abstract SceneDecoratorFactory getSceneDecoratorFactory();

    public abstract Map<Object, Map<ResourceReference, ResourceValue>> getDefaultProperties();

    public abstract Map<Object, ResourceReference> getDefaultStyles();

    @NotNull
    protected HitProvider getHitProvider(@NotNull NlComponent component) {
        return this.myHitProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activate(@NotNull Object source) {
        Object object = this.myActivationLock;
        synchronized (object) {
            if (!this.myIsActivated) {
                AndroidFacet facet = this.myModel.getFacet();
                VirtualFile file2 = this.myModel.getVirtualFile();
                Configuration config = this.myModel.getConfiguration();
                ResourceNotificationManager manager = ResourceNotificationManager.getInstance((Project)this.myModel.getProject());
                manager.addListener((ResourceNotificationManager.ResourceChangeListener)this, facet, file2, config);
                this.myIsActivated = true;
            }
        }
        return this.getModel().activate(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deactivate(@NotNull Object source) {
        Object object = this.myActivationLock;
        synchronized (object) {
            if (this.myIsActivated) {
                AndroidFacet facet = this.myModel.getFacet();
                VirtualFile file2 = this.myModel.getVirtualFile();
                Configuration config = this.myModel.getConfiguration();
                ResourceNotificationManager manager = ResourceNotificationManager.getInstance((Project)this.myModel.getProject());
                manager.removeListener((ResourceNotificationManager.ResourceChangeListener)this, facet, file2, config);
                this.myIsActivated = false;
            }
        }
        return this.getModel().deactivate(source);
    }

    public boolean isOutOfDate() {
        return false;
    }

    public void resourcesChanged(@NotNull ImmutableSet<ResourceNotificationManager.Reason> reasons) {
        for (ResourceNotificationManager.Reason reason : reasons) {
            switch (reason) {
                case RESOURCE_EDIT: {
                    this.myModel.notifyModifiedViaUpdateQueue(NlModel.ChangeType.RESOURCE_EDIT);
                    break;
                }
                case EDIT: {
                    this.myModel.notifyModifiedViaUpdateQueue(NlModel.ChangeType.EDIT);
                    break;
                }
                case IMAGE_RESOURCE_CHANGED: {
                    RenderUtils.clearCache((ImmutableCollection)ImmutableList.of((Object)this.myModel.getConfiguration()));
                    this.myModel.notifyModified(NlModel.ChangeType.RESOURCE_CHANGED);
                    break;
                }
                case GRADLE_SYNC: 
                case PROJECT_BUILD: 
                case VARIANT_CHANGED: 
                case SDK_CHANGED: {
                    RenderUtils.clearCache((ImmutableCollection)ImmutableList.of((Object)this.myModel.getConfiguration()));
                    this.myModel.notifyModified(NlModel.ChangeType.BUILD);
                    break;
                }
                case CONFIGURATION_CHANGED: {
                    this.myModel.notifyModified(NlModel.ChangeType.CONFIGURATION_CHANGE);
                }
            }
        }
    }

    public static interface SceneComponentHierarchyProvider {
        @NotNull
        public List<SceneComponent> createHierarchy(@NotNull SceneManager var1, @NotNull NlComponent var2);

        public void syncFromNlComponent(@NotNull SceneComponent var1);
    }

    public static class DefaultSceneUpdateListener
    implements SceneUpdateListener {
        @Override
        public void onUpdate(@NotNull NlComponent component, @NotNull DesignSurface<?> designSurface) {
        }
    }

    public static interface SceneUpdateListener {
        public void onUpdate(@NotNull NlComponent var1, @NotNull DesignSurface<?> var2);
    }
}

