/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.BlueprintColorSet;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class SceneContext {
    private final ScenePicker myGraphicsPicker = new ScenePicker();
    private Object myFoundObject;
    private Long myTime;
    private int myMouseX = -1;
    private int myMouseY = -1;
    private boolean myShowOnlySelection = false;
    @NotNull
    protected final Rectangle myRenderableBounds = new Rectangle();
    private static SceneContext lazySingleton;

    public SceneContext() {
        this.myTime = System.currentTimeMillis();
        this.myGraphicsPicker.setSelectListener((over, dist) -> {
            this.myFoundObject = over;
        });
    }

    public void setShowOnlySelection(boolean value2) {
        this.myShowOnlySelection = value2;
    }

    public long getTime() {
        return this.myTime;
    }

    public void setTime(long time) {
        this.myTime = time;
    }

    public void setMouseLocation(int x, int y) {
        this.myMouseX = x;
        this.myMouseY = y;
    }

    public int getMouseX() {
        return this.myMouseX;
    }

    public int getMouseY() {
        return this.myMouseY;
    }

    public void repaint() {
    }

    public int getSwingXDip(float x) {
        return (int)x;
    }

    public int getSwingYDip(float y) {
        return (int)y;
    }

    public int getSwingX(int x) {
        return x;
    }

    public int getSwingY(int y) {
        return y;
    }

    public int getSwingDimensionDip(float dim2) {
        return (int)dim2;
    }

    public int getSwingDimension(int dim2) {
        return dim2;
    }

    @NotNull
    public abstract ColorSet getColorSet();

    @NotNull
    public ScenePicker getScenePicker() {
        return this.myGraphicsPicker;
    }

    @Nullable
    public Object findClickedGraphics(int x, int y) {
        this.myFoundObject = null;
        this.myGraphicsPicker.find(x, y);
        return this.myFoundObject;
    }

    public double getScale() {
        return 1.0;
    }

    public final void setRenderableBounds(@NotNull Rectangle bounds2) {
        this.myRenderableBounds.setBounds(bounds2);
    }

    @NotNull
    public final Rectangle getRenderableBounds() {
        return this.myRenderableBounds;
    }

    @TestOnly
    @NotNull
    public static SceneContext get() {
        if (lazySingleton == null) {
            lazySingleton = new IdentitySceneContext();
        }
        return lazySingleton;
    }

    @Deprecated
    @NotNull
    public static SceneContext get(@NotNull SceneView sceneView) {
        return sceneView.getContext();
    }

    @Nullable
    public DesignSurface<?> getSurface() {
        return null;
    }

    public float pxToDp(int px) {
        return (float)px * Coordinates.DEFAULT_DENSITY;
    }

    public boolean showOnlySelection() {
        return this.myShowOnlySelection;
    }

    @TestOnly
    private static class IdentitySceneContext
    extends SceneContext {
        private ColorSet myColorSet = new BlueprintColorSet();

        private IdentitySceneContext() {
        }

        @Override
        @NotNull
        public ColorSet getColorSet() {
            return this.myColorSet;
        }
    }
}

