/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.util.NlTreeDumper;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NlComponentUtil {
    @NotNull
    public static Multimap<NlComponent, NlComponent> groupSiblings(@NotNull Collection<? extends NlComponent> components) {
        if (components.isEmpty()) {
            return ImmutableMultimap.of();
        }
        if (components.size() == 1) {
            ArrayListMultimap siblingLists = ArrayListMultimap.create((int)1, (int)1);
            NlComponent component = components.iterator().next();
            siblingLists.put((Object)component.getParent(), (Object)component);
            return siblingLists;
        }
        HashMultimap siblingLists = HashMultimap.create();
        for (NlComponent nlComponent : components) {
            NlComponent parent = nlComponent.getParent();
            siblingLists.put((Object)parent, (Object)nlComponent);
        }
        return siblingLists;
    }

    public static boolean isDescendant(@NotNull NlComponent potentialDescendant, @NotNull Collection<NlComponent> potentialAncestors) {
        HashSet<NlComponent> visited = new HashSet<NlComponent>();
        for (NlComponent component : potentialAncestors) {
            for (NlComponent same = potentialDescendant; same != null; same = same.getParent()) {
                if (!visited.add(same)) {
                    assert (false) : "Loop found in NlModel. \n" + NlTreeDumper.dumpTree((List<NlComponent>)ImmutableList.of((Object)same));
                    return false;
                }
                if (same != component) continue;
                return true;
            }
            visited.clear();
        }
        return false;
    }
}

