/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import com.android.tools.idea.common.error.DesignerCommonIssueNode;
import com.android.tools.idea.common.error.DesignerCommonIssueNodeKt;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueSource;
import com.android.tools.idea.common.error.MyOpenFileDescriptor;
import com.android.tools.idea.common.error.NlComponentIssueSource;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tree.LeafState;
import com.intellij.util.ui.EmptyIcon;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u000fH\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u000f\u0010\u001b\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u000fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0014R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/common/error/IssueNode;", "Lcom/android/tools/idea/common/error/DesignerCommonIssueNode;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "issue", "Lcom/android/tools/idea/common/error/Issue;", "parent", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/android/tools/idea/common/error/Issue;Lcom/android/tools/idea/common/error/DesignerCommonIssueNode;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getIssue", "()Lcom/android/tools/idea/common/error/Issue;", "getParent", "()Lcom/android/tools/idea/common/error/DesignerCommonIssueNode;", "createNodeDisplayText", "", "equals", "", "other", "", "getChildren", "", "getLeafState", "Lcom/intellij/ui/tree/LeafState;", "getName", "getNavigatable", "Lcom/intellij/pom/Navigatable;", "getVirtualFile", "Lorg/jetbrains/annotations/NotNull;", "hashCode", "", "toString", "updatePresentation", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.android.designer"})
@SourceDebugExtension(value={"SMAP\nDesignerCommonIssueNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesignerCommonIssueNode.kt\ncom/android/tools/idea/common/error/IssueNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,525:1\n1#2:526\n*E\n"})
public class IssueNode
extends DesignerCommonIssueNode {
    @Nullable
    private final VirtualFile file;
    @NotNull
    private final Issue issue;
    @Nullable
    private final DesignerCommonIssueNode parent;

    public IssueNode(@Nullable VirtualFile file2, @NotNull Issue issue, @Nullable DesignerCommonIssueNode parent) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        DesignerCommonIssueNode designerCommonIssueNode = parent;
        super((Project)(designerCommonIssueNode != null ? designerCommonIssueNode.getProject() : null), (NodeDescriptor<DesignerCommonIssueNode>)((NodeDescriptor)parent));
        this.file = file2;
        this.issue = issue;
        this.parent = parent;
    }

    @Nullable
    public final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public final Issue getIssue() {
        return this.issue;
    }

    @Nullable
    public final DesignerCommonIssueNode getParent() {
        return this.parent;
    }

    @NotNull
    public LeafState getLeafState() {
        return LeafState.ALWAYS;
    }

    @Override
    @NotNull
    public String getName() {
        return this.createNodeDisplayText();
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile2;
        VirtualFile virtualFile3 = this.file;
        if (virtualFile3 != null) {
            VirtualFile it = virtualFile3;
            boolean bl = false;
            virtualFile2 = BackedVirtualFile.getOriginFileIfBacked((VirtualFile)this.file);
        } else {
            virtualFile2 = null;
        }
        return virtualFile2;
    }

    @Override
    @NotNull
    public List<DesignerCommonIssueNode> getChildren() {
        return CollectionsKt.emptyList();
    }

    @Override
    @Nullable
    public Navigatable getNavigatable() {
        Navigatable navigatable;
        IssueSource issueSource = this.issue.getSource();
        NlAttributesHolder nlAttributesHolder = issueSource instanceof NlComponentIssueSource ? (NlComponentIssueSource)issueSource : null;
        Navigatable navigatable2 = nlAttributesHolder != null && (nlAttributesHolder = ((NlComponentIssueSource)nlAttributesHolder).getComponent()) != null ? ((NlComponent)nlAttributesHolder).getNavigatable() : (navigatable = null);
        if (navigatable == null) {
            VirtualFile targetFile = this.getVirtualFile();
            if (this.getProject() != null && targetFile != null) {
                navigatable = (Navigatable)new OpenFileDescriptor(this.getProject(), targetFile, -1);
            }
        }
        if (navigatable instanceof OpenFileDescriptor) {
            return (Navigatable)new MyOpenFileDescriptor((OpenFileDescriptor)navigatable);
        }
        return navigatable;
    }

    @Override
    protected void updatePresentation(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        String nodeDisplayText = this.createNodeDisplayText();
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.find((HighlightSeverity)this.issue.getSeverity());
        Icon icon2 = highlightDisplayLevel != null ? highlightDisplayLevel.getIcon() : null;
        if (icon2 == null) {
            Icon icon3;
            IssueNode it = this;
            boolean bl = false;
            int issueSeverityLevel = this.issue.getSeverity().myVal;
            Icon icon4 = null;
            for (HighlightSeverity severity : DesignerCommonIssueNodeKt.getDESCEND_ORDER_DEFAULT_SEVERITIES()) {
                if (issueSeverityLevel < severity.myVal) continue;
                HighlightDisplayLevel highlightDisplayLevel2 = HighlightDisplayLevel.find((HighlightSeverity)severity);
                icon4 = highlightDisplayLevel2 != null ? highlightDisplayLevel2.getIcon() : null;
                break;
            }
            if ((icon3 = icon4) == null) {
                icon3 = EmptyIcon.ICON_16;
            }
            icon2 = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"let {\n      val issueSev\u2026: EmptyIcon.ICON_16\n    }");
        }
        Icon icon5 = icon2;
        presentation.setIcon(icon5);
        presentation.addText(nodeDisplayText, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    private final String createNodeDisplayText() {
        IssueSource source = this.issue.getSource();
        return source instanceof NlComponentIssueSource ? source.getDisplayText() + ": " + this.issue.getSummary() : this.issue.getSummary();
    }

    public int hashCode() {
        Object[] objectArray = new Object[3];
        NodeDescriptor nodeDescriptor = this.getParentDescriptor();
        objectArray[0] = nodeDescriptor != null ? nodeDescriptor.getElement() : null;
        objectArray[1] = this.file;
        objectArray[2] = this.issue;
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        IssueNode issueNode = other instanceof IssueNode ? (IssueNode)((Object)other) : null;
        if (issueNode == null) {
            return false;
        }
        IssueNode that = issueNode;
        NodeDescriptor nodeDescriptor = that.getParentDescriptor();
        NodeDescriptor nodeDescriptor2 = this.getParentDescriptor();
        return Intrinsics.areEqual((Object)(nodeDescriptor != null ? nodeDescriptor.getElement() : null), (Object)(nodeDescriptor2 != null ? nodeDescriptor2.getElement() : null)) && Intrinsics.areEqual((Object)that.issue, (Object)this.issue);
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        Object object = this.file;
        if (object != null && (object = object.getCanonicalPath()) != null) {
            Object it = object;
            boolean bl = false;
            builder2.append((String)it).append(", ");
        }
        builder2.append(this.issue.toString());
        String string = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }
}

