/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueProvider;
import com.android.tools.idea.common.error.IssueProviderListener;
import com.android.tools.idea.common.error.IssueSource;
import com.android.tools.idea.common.error.TooManyIssuesIssue;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ModalityUiUtil;
import icons.StudioIcons;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class IssueModel
implements Disposable {
    private static final int MAX_ISSUE_NUMBER_LIMIT = 200;
    @NotNull
    private final Project myProject;
    private final int myIssueNumberLimit;
    @NotNull
    private ImmutableList<Issue> myIssues = ImmutableList.of();
    private final ListenerCollection<IssueModelListener> myListeners;
    protected int myWarningCount;
    protected int myErrorCount;
    @VisibleForTesting
    public final Runnable myUpdateCallback = () -> this.updateErrorsList();
    private final Set<IssueProvider> myIssueProviders = new HashSet<IssueProvider>();
    @NotNull
    private final AtomicBoolean myIsActivated = new AtomicBoolean(true);

    private IssueModel(@NotNull Disposable parentDisposable, @NotNull Project project, @NotNull Executor listenerExecutor, int issueNumberLimit) {
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myProject = project;
        this.myListeners = ListenerCollection.createWithExecutor((Executor)listenerExecutor);
        this.myIssueNumberLimit = issueNumberLimit;
    }

    public IssueModel(@NotNull Disposable parentDisposable, @NotNull Project project) {
        this(parentDisposable, project, command -> ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), (Runnable)command), 200);
    }

    @TestOnly
    public static IssueModel createForTesting(@NotNull Disposable parentDisposable, @NotNull Project project, int issueNumberLimit) {
        return new IssueModel(parentDisposable, project, MoreExecutors.directExecutor(), issueNumberLimit);
    }

    @TestOnly
    public static IssueModel createForTesting(@NotNull Disposable parentDisposable, @NotNull Project project) {
        return new IssueModel(parentDisposable, project, MoreExecutors.directExecutor(), 200);
    }

    @Nullable
    public Issue getHighestSeverityIssue(@NotNull NlComponent component) {
        IssueSource componentSource = IssueSource.fromNlComponent(component);
        Issue[] filtered = (Issue[])this.myIssues.stream().filter(it -> componentSource.equals(it.getSource())).toArray(Issue[]::new);
        if (filtered.length == 0) {
            return null;
        }
        Issue max = filtered[0];
        for (int i = 1; i < filtered.length; ++i) {
            Issue it2 = filtered[i];
            if (max.getSeverity().compareTo(it2.getSeverity()) >= 0) continue;
            max = it2;
        }
        return max;
    }

    public void dispose() {
        this.myIssueProviders.clear();
        this.myListeners.clear();
    }

    @Nullable
    public static Icon getIssueIcon(@NotNull HighlightSeverity severity, boolean selected) {
        boolean isError;
        boolean bl = isError = severity == HighlightSeverity.ERROR;
        if (selected) {
            return isError ? StudioIcons.Common.ERROR_INLINE_SELECTED : StudioIcons.Common.WARNING_INLINE_SELECTED;
        }
        return isError ? StudioIcons.Common.ERROR_INLINE : StudioIcons.Common.WARNING_INLINE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateErrorsList() {
        ImmutableSet providers2;
        this.myWarningCount = 0;
        this.myErrorCount = 0;
        ImmutableList.Builder issueListBuilder = ImmutableList.builder();
        UnmodifiableIterator unmodifiableIterator = this.myIssueProviders;
        synchronized (unmodifiableIterator) {
            providers2 = ImmutableSet.copyOf(this.myIssueProviders);
        }
        for (IssueProvider provider2 : providers2) {
            provider2.collectIssues((ImmutableCollection.Builder<Issue>)issueListBuilder);
        }
        ImmutableList newIssueList = issueListBuilder.build();
        if (newIssueList.size() > this.myIssueNumberLimit) {
            newIssueList = ImmutableList.builder().addAll((Iterable)newIssueList.subList(0, this.myIssueNumberLimit)).add((Object)new TooManyIssuesIssue(newIssueList.size() - this.myIssueNumberLimit)).build();
        }
        newIssueList.forEach(issue -> this.updateIssuesCounts((Issue)issue));
        this.myIssues = newIssueList;
        this.myListeners.forEach(IssueModelListener::errorModelChanged);
        if (this.myIsActivated.get()) {
            ((IssueProviderListener)this.myProject.getMessageBus().syncPublisher(IssueProviderListener.TOPIC)).issueUpdated(this, (List<? extends Issue>)newIssueList);
        }
    }

    private void updateIssuesCounts(@NotNull Issue issue) {
        if (issue.getSeverity().equals((Object)HighlightSeverity.WARNING)) {
            ++this.myWarningCount;
        } else if (issue.getSeverity().equals((Object)HighlightSeverity.ERROR)) {
            ++this.myErrorCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIssueProvider(@NotNull IssueProvider issueProvider2, boolean update2) {
        Set<IssueProvider> set = this.myIssueProviders;
        synchronized (set) {
            this.myIssueProviders.add(issueProvider2);
        }
        issueProvider2.addListener(this.myUpdateCallback);
        if (update2) {
            this.updateErrorsList();
        }
    }

    public void addIssueProvider(@NotNull IssueProvider issueProvider2) {
        this.addIssueProvider(issueProvider2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIssueProvider(@NotNull IssueProvider issueProvider2) {
        Set<IssueProvider> set = this.myIssueProviders;
        synchronized (set) {
            this.myIssueProviders.remove(issueProvider2);
        }
        issueProvider2.removeListener(this.myUpdateCallback);
        this.updateErrorsList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllIssueProviders() {
        Set<IssueProvider> set = this.myIssueProviders;
        synchronized (set) {
            this.myIssueProviders.forEach(provider2 -> provider2.removeListener(this.myUpdateCallback));
            this.myIssueProviders.clear();
        }
    }

    @NotNull
    public ImmutableList<Issue> getIssues() {
        return this.myIssues;
    }

    public int getIssueCount() {
        return this.myIssues.size();
    }

    public void addErrorModelListener(@NotNull IssueModelListener listener2) {
        this.myListeners.add((Object)listener2);
    }

    public void removeErrorModelListener(@NotNull IssueModelListener listener2) {
        this.myListeners.remove((Object)listener2);
    }

    public int getWarningCount() {
        return this.myWarningCount;
    }

    public int getErrorCount() {
        return this.myErrorCount;
    }

    public boolean hasIssues() {
        return !this.myIssues.isEmpty();
    }

    public void activate() {
        this.myIsActivated.set(true);
        ((IssueProviderListener)this.myProject.getMessageBus().syncPublisher(IssueProviderListener.TOPIC)).issueUpdated(this, (List<? extends Issue>)this.myIssues);
    }

    public void deactivate() {
        this.myIsActivated.set(false);
        ((IssueProviderListener)this.myProject.getMessageBus().syncPublisher(IssueProviderListener.TOPIC)).issueUpdated(this, Collections.emptyList());
    }

    public static interface IssueModelListener {
        public void errorModelChanged();
    }
}

