/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.editor;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.editor.DesignToolsSplitEditor;
import com.android.tools.idea.common.editor.DesignerEditor;
import com.android.tools.idea.common.editor.DesignerEditorPanel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.common.type.DesignerTypeRegistrar;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.QuickDefinitionProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DesignerEditorProvider
implements FileEditorProvider,
QuickDefinitionProvider,
DumbAware {
    @NotNull
    private final List<DesignerEditorFileType> myAcceptedTypes;

    protected DesignerEditorProvider(@NotNull List<DesignerEditorFileType> acceptedTypes) {
        this.myAcceptedTypes = acceptedTypes;
        this.myAcceptedTypes.forEach(DesignerTypeRegistrar.INSTANCE::register);
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile virtualFile2) {
        PsiFile psiFile2 = AndroidPsiUtils.getPsiFileSafely((Project)project, (VirtualFile)virtualFile2);
        if (psiFile2 instanceof XmlFile) {
            XmlFile xmlFile = (XmlFile)psiFile2;
            return this.myAcceptedTypes.stream().anyMatch(type -> type.isResourceTypeOf((PsiFile)xmlFile));
        }
        return false;
    }

    @NotNull
    public final FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        DesignerEditor designEditor = this.createDesignEditor(project, file2);
        DesignerEditorPanel editorPanel2 = designEditor.getComponent();
        TextEditor textEditor = (TextEditor)TextEditorProvider.getInstance().createEditor(project, file2);
        this.addCaretListener(textEditor, designEditor);
        editorPanel2.getSurface().setFileEditorDelegate((FileEditor)textEditor);
        DesignToolsSplitEditor splitEditor = new DesignToolsSplitEditor(textEditor, designEditor, project);
        editorPanel2.getWorkBench().setFileEditor((FileEditor)splitEditor);
        DataManager.registerDataProvider((JComponent)editorPanel2, (DataProvider)splitEditor);
        return splitEditor;
    }

    private void addCaretListener(final @NotNull TextEditor editor, final @NotNull DesignerEditor designEditor) {
        final CaretModel caretModel = editor.getEditor().getCaretModel();
        final MergingUpdateQueue updateQueue = new MergingUpdateQueue("split.editor.preview.edit", 250, true, null, (Disposable)designEditor, null, Alarm.ThreadToUse.SWING_THREAD);
        updateQueue.setRestartTimerOnAdd(true);
        final CaretListener caretListener2 = new CaretListener(){

            public void caretAdded(@NotNull CaretEvent event) {
                this.caretPositionChanged(event);
            }

            public void caretPositionChanged(@NotNull CaretEvent event) {
                final DesignSurface<?> surface2 = designEditor.getComponent().getSurface();
                SceneView sceneView = surface2.getFocusedSceneView();
                int offset = caretModel.getOffset();
                if (sceneView == null || offset == -1) {
                    return;
                }
                NlModel model2 = sceneView.getSceneManager().getModel();
                ImmutableList<NlComponent> views = model2.findByOffset(offset);
                if (views.isEmpty()) {
                    views = model2.getComponents();
                }
                DesignerEditorProvider.this.handleCaretChanged(sceneView, views);
                updateQueue.queue(new Update("Design editor update"){

                    public void run() {
                        surface2.repaint();
                    }

                    public boolean canEat(Update update2) {
                        return true;
                    }
                });
            }
        };
        caretModel.addCaretListener(caretListener2);
        designEditor.getComponent().getSurface().addListener(new DesignSurfaceListener(){

            @Override
            @UiThread
            public void modelChanged(@NotNull DesignSurface<?> surface2, @Nullable NlModel model2) {
                surface2.removeListener(this);
                CaretModel caretModel = editor.getEditor().getCaretModel();
                caretListener2.caretPositionChanged(new CaretEvent(caretModel.getCurrentCaret(), caretModel.getLogicalPosition(), caretModel.getLogicalPosition()));
            }
        });
    }

    protected abstract void handleCaretChanged(@NotNull SceneView var1, @NotNull ImmutableList<NlComponent> var2);

    @NotNull
    public abstract DesignerEditor createDesignEditor(@NotNull Project var1, @NotNull VirtualFile var2);

    @NotNull
    public abstract String getEditorTypeId();

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }
}

