/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.preloading;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.kotlin.preloading.ClassCondition;
import org.jetbrains.kotlin.preloading.ClassHandler;
import org.jetbrains.kotlin.preloading.MemoryBasedClassLoader;
import org.jetbrains.kotlin.preloading.ResourceData;

public class ClassPreloadingUtils {
    public static ClassLoader preloadClasses(Collection<File> jarFiles, int classCountEstimation, ClassLoader parentClassLoader, ClassCondition classesToLoadByParent, ClassHandler handler) throws IOException {
        Map<String, Object> entries = ClassPreloadingUtils.loadAllClassesFromJars(jarFiles, classCountEstimation, handler);
        Collection<File> classpath = ClassPreloadingUtils.mergeClasspathFromManifests(entries);
        classpath.removeAll(jarFiles);
        if (!classpath.isEmpty()) {
            parentClassLoader = ClassPreloadingUtils.preloadClasses(classpath, classCountEstimation, parentClassLoader, null, handler);
        }
        return new MemoryBasedClassLoader(classesToLoadByParent, parentClassLoader, entries, handler, ClassPreloadingUtils.createFallbackClassLoader(jarFiles));
    }

    private static URLClassLoader createFallbackClassLoader(Collection<File> files2) throws IOException {
        ArrayList<URL> urls2 = new ArrayList<URL>(files2.size());
        for (File file2 : files2) {
            urls2.add(file2.toURI().toURL());
        }
        return new URLClassLoader(urls2.toArray(new URL[urls2.size()]), null);
    }

    public static ClassLoader preloadClasses(Collection<File> jarFiles, int classCountEstimation, ClassLoader parentClassLoader, ClassCondition classesToLoadByParent) throws IOException {
        return ClassPreloadingUtils.preloadClasses(jarFiles, classCountEstimation, parentClassLoader, classesToLoadByParent, null);
    }

    private static Collection<File> mergeClasspathFromManifests(Map<String, Object> preloadedResources) throws IOException {
        Object manifest = preloadedResources.get("META-INF/MANIFEST.MF");
        if (manifest instanceof ResourceData) {
            return ClassPreloadingUtils.extractManifestClasspath((ResourceData)manifest);
        }
        if (manifest instanceof ArrayList) {
            ArrayList<File> result2 = new ArrayList<File>();
            for (ResourceData data2 : (ArrayList)manifest) {
                result2.addAll(ClassPreloadingUtils.extractManifestClasspath(data2));
            }
            return result2;
        }
        assert (manifest == null) : "Resource map should contain ResourceData or ArrayList<ResourceData>: " + manifest;
        return Collections.emptyList();
    }

    private static Collection<File> extractManifestClasspath(ResourceData manifestData) throws IOException {
        Manifest manifest = new Manifest(new ByteArrayInputStream(manifestData.bytes));
        String classpathSpaceSeparated = (String)manifest.getMainAttributes().get(Attributes.Name.CLASS_PATH);
        if (classpathSpaceSeparated == null) {
            return Collections.emptyList();
        }
        ArrayList<File> classpath = new ArrayList<File>(1);
        for (String jar : classpathSpaceSeparated.split(" ")) {
            if (".".equals(jar)) continue;
            if (!jar.endsWith(".jar")) {
                throw new UnsupportedOperationException("Class-Path attribute should only contain paths to JAR files: " + jar);
            }
            classpath.add(new File(manifestData.jarFile.getParent(), jar));
        }
        return classpath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> loadAllClassesFromJars(Collection<File> jarFiles, int classNumberEstimate, ClassHandler handler) throws IOException {
        HashMap<String, Object> resources = new HashMap<String, Object>((int)((double)classNumberEstimate / 0.75));
        for (File jarFile : jarFiles) {
            if (handler != null) {
                handler.beforeLoadJar(jarFile);
            }
            FileInputStream fileInputStream = new FileInputStream(jarFile);
            try {
                ZipEntry entry;
                byte[] buffer = new byte[10240];
                ZipInputStream stream = new ZipInputStream(new BufferedInputStream(fileInputStream, 524288));
                while ((entry = stream.getNextEntry()) != null) {
                    int count;
                    if (entry.isDirectory()) continue;
                    int size = (int)entry.getSize();
                    int effectiveSize = size < 0 ? 32 : size;
                    ByteArrayOutputStream bytes2 = new ByteArrayOutputStream(effectiveSize);
                    while ((count = stream.read(buffer)) > 0) {
                        bytes2.write(buffer, 0, count);
                    }
                    String name = entry.getName();
                    byte[] data2 = bytes2.toByteArray();
                    if (handler != null) {
                        data2 = handler.instrument(name, data2);
                    }
                    ResourceData resourceData = new ResourceData(jarFile, name, data2);
                    Object previous = resources.get(name);
                    if (previous == null) {
                        resources.put(name, resourceData);
                        continue;
                    }
                    if (previous instanceof ResourceData) {
                        ArrayList<ResourceData> list = new ArrayList<ResourceData>();
                        list.add((ResourceData)previous);
                        list.add(resourceData);
                        resources.put(name, list);
                        continue;
                    }
                    assert (previous instanceof ArrayList) : "Resource map should contain ResourceData or ArrayList<ResourceData>: " + name;
                    ((ArrayList)previous).add(resourceData);
                }
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (handler == null) continue;
            handler.afterLoadJar(jarFile);
        }
        for (File value2 : resources.values()) {
            if (!(value2 instanceof ArrayList)) continue;
            ((ArrayList)((Object)value2)).trimToSize();
        }
        return resources;
    }
}

