/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.model;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentUtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2MetadataCompilerArguments;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.KotlinModuleKind;
import org.jetbrains.kotlin.jps.model.JpsKotlinCompilerSettings;
import org.jetbrains.kotlin.jps.model.JpsKotlinFacetModuleExtension;
import org.jetbrains.kotlin.jps.model.ProjectSettingsKt;
import org.jetbrains.kotlin.platform.TargetPlatform;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\u001a\"\u00100\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00022\u000e\u00101\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010\u0001H\u0002\u001a\u001e\u00102\u001a\u0002H3\"\n\b\u0000\u00103\u0018\u0001*\u00020\u0015*\u00020\u0002H\u0082\b\u00a2\u0006\u0002\u0010\u0017\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\"\u0015\u0010\b\u001a\u00020\t*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0015\u0010\f\u001a\u00020\r*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0015\u0010\u0010\u001a\u00020\u0011*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0015\u0010\u0014\u001a\u00020\u0015*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\"\u0015\u0010\u0018\u001a\u00020\u0019*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\"\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\"\u0015\u0010 \u001a\u00020!*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\"\u0017\u0010$\u001a\u0004\u0018\u00010%*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\"\u0017\u0010(\u001a\u0004\u0018\u00010)*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\"\u001b\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0004\"\u0017\u0010.\u001a\u0004\u0018\u00010)*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b/\u0010+\u00a8\u00064"}, d2={"expectedByModules", "", "Lorg/jetbrains/jps/model/module/JpsModule;", "getExpectedByModules", "(Lorg/jetbrains/jps/model/module/JpsModule;)Ljava/util/List;", "isTestModule", "", "(Lorg/jetbrains/jps/model/module/JpsModule;)Z", "k2JsCompilerArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "getK2JsCompilerArguments", "(Lorg/jetbrains/jps/model/module/JpsModule;)Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "k2JvmCompilerArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "getK2JvmCompilerArguments", "(Lorg/jetbrains/jps/model/module/JpsModule;)Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "k2MetadataCompilerArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2MetadataCompilerArguments;", "getK2MetadataCompilerArguments", "(Lorg/jetbrains/jps/model/module/JpsModule;)Lorg/jetbrains/kotlin/cli/common/arguments/K2MetadataCompilerArguments;", "kotlinCompilerArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "getKotlinCompilerArguments", "(Lorg/jetbrains/jps/model/module/JpsModule;)Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "kotlinCompilerSettings", "Lorg/jetbrains/kotlin/config/CompilerSettings;", "getKotlinCompilerSettings", "(Lorg/jetbrains/jps/model/module/JpsModule;)Lorg/jetbrains/kotlin/config/CompilerSettings;", "kotlinFacet", "Lorg/jetbrains/kotlin/jps/model/JpsKotlinFacetModuleExtension;", "getKotlinFacet", "(Lorg/jetbrains/jps/model/module/JpsModule;)Lorg/jetbrains/kotlin/jps/model/JpsKotlinFacetModuleExtension;", "kotlinKind", "Lorg/jetbrains/kotlin/config/KotlinModuleKind;", "getKotlinKind", "(Lorg/jetbrains/jps/model/module/JpsModule;)Lorg/jetbrains/kotlin/config/KotlinModuleKind;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "(Lorg/jetbrains/jps/model/module/JpsModule;)Lorg/jetbrains/kotlin/platform/TargetPlatform;", "productionOutputFilePath", "", "getProductionOutputFilePath", "(Lorg/jetbrains/jps/model/module/JpsModule;)Ljava/lang/String;", "sourceSetModules", "getSourceSetModules", "testOutputFilePath", "getTestOutputFilePath", "findDependencies", "moduleNames", "getCompilerArguments", "T", "jps-plugin"})
public final class ModuleSettingsKt {
    @Nullable
    public static final JpsKotlinFacetModuleExtension getKotlinFacet(@NotNull JpsModule $this$kotlinFacet) {
        Intrinsics.checkNotNullParameter((Object)$this$kotlinFacet, (String)"<this>");
        return (JpsKotlinFacetModuleExtension)$this$kotlinFacet.getContainer().getChild((JpsElementChildRole)JpsKotlinFacetModuleExtension.Companion.getKIND());
    }

    @Nullable
    public static final TargetPlatform getPlatform(@NotNull JpsModule $this$platform) {
        Intrinsics.checkNotNullParameter((Object)$this$platform, (String)"<this>");
        Object object = ModuleSettingsKt.getKotlinFacet($this$platform);
        return object != null && (object = object.getSettings()) != null ? ((KotlinFacetSettings)object).getTargetPlatform() : null;
    }

    @NotNull
    public static final KotlinModuleKind getKotlinKind(@NotNull JpsModule $this$kotlinKind) {
        Intrinsics.checkNotNullParameter((Object)$this$kotlinKind, (String)"<this>");
        Object object = ModuleSettingsKt.getKotlinFacet($this$kotlinKind);
        if (object == null || (object = object.getSettings()) == null || (object = ((KotlinFacetSettings)object).getKind()) == null) {
            object = KotlinModuleKind.DEFAULT;
        }
        return object;
    }

    public static final boolean isTestModule(@NotNull JpsModule $this$isTestModule) {
        Intrinsics.checkNotNullParameter((Object)$this$isTestModule, (String)"<this>");
        Object object = ModuleSettingsKt.getKotlinFacet($this$isTestModule);
        return object != null && (object = object.getSettings()) != null ? ((KotlinFacetSettings)object).isTestModule() : false;
    }

    @NotNull
    public static final List<JpsModule> getSourceSetModules(@NotNull JpsModule $this$sourceSetModules) {
        Intrinsics.checkNotNullParameter((Object)$this$sourceSetModules, (String)"<this>");
        Object object = ModuleSettingsKt.getKotlinFacet($this$sourceSetModules);
        return ModuleSettingsKt.findDependencies($this$sourceSetModules, object != null && (object = object.getSettings()) != null ? ((KotlinFacetSettings)object).getSourceSetNames() : null);
    }

    @NotNull
    public static final List<JpsModule> getExpectedByModules(@NotNull JpsModule $this$expectedByModules) {
        Intrinsics.checkNotNullParameter((Object)$this$expectedByModules, (String)"<this>");
        Object object = ModuleSettingsKt.getKotlinFacet($this$expectedByModules);
        return ModuleSettingsKt.findDependencies($this$expectedByModules, object != null && (object = object.getSettings()) != null ? ((KotlinFacetSettings)object).getImplementedModuleNames() : null);
    }

    private static final List<JpsModule> findDependencies(JpsModule $this$findDependencies, List<String> moduleNames) {
        if (moduleNames == null || moduleNames.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Set result2 = new LinkedHashSet();
        JpsJavaExtensionService.dependencies((JpsModule)$this$findDependencies).processModules(arg_0 -> ModuleSettingsKt.findDependencies$lambda$0((Function1)new Function1<JpsModule, Unit>(moduleNames, (Set<JpsModule>)result2){
            final /* synthetic */ List<String> $moduleNames;
            final /* synthetic */ Set<JpsModule> $result;
            {
                this.$moduleNames = $moduleNames;
                this.$result = $result;
                super(1);
            }

            public final void invoke(JpsModule it) {
                if (this.$moduleNames.contains(it.getName())) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    this.$result.add(it);
                }
            }
        }, arg_0));
        return CollectionsKt.toList((Iterable)result2);
    }

    @Nullable
    public static final String getProductionOutputFilePath(@NotNull JpsModule $this$productionOutputFilePath) {
        Intrinsics.checkNotNullParameter((Object)$this$productionOutputFilePath, (String)"<this>");
        Object object = ModuleSettingsKt.getKotlinFacet($this$productionOutputFilePath);
        if (object == null || (object = object.getSettings()) == null) {
            return null;
        }
        Object facetSettings = object;
        if (((KotlinFacetSettings)facetSettings).getUseProjectSettings()) {
            return null;
        }
        return ((KotlinFacetSettings)facetSettings).getProductionOutputPath();
    }

    @Nullable
    public static final String getTestOutputFilePath(@NotNull JpsModule $this$testOutputFilePath) {
        Intrinsics.checkNotNullParameter((Object)$this$testOutputFilePath, (String)"<this>");
        Object object = ModuleSettingsKt.getKotlinFacet($this$testOutputFilePath);
        if (object == null || (object = object.getSettings()) == null) {
            return null;
        }
        Object facetSettings = object;
        if (((KotlinFacetSettings)facetSettings).getUseProjectSettings()) {
            return null;
        }
        return ((KotlinFacetSettings)facetSettings).getTestOutputPath();
    }

    @NotNull
    public static final CompilerSettings getKotlinCompilerSettings(@NotNull JpsModule $this$kotlinCompilerSettings) {
        Intrinsics.checkNotNullParameter((Object)$this$kotlinCompilerSettings, (String)"<this>");
        JpsProject jpsProject = $this$kotlinCompilerSettings.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)jpsProject, (String)"project");
        CompilerSettings defaultSettings = ArgumentUtilsKt.copyBean(ProjectSettingsKt.getKotlinCompilerSettings(jpsProject));
        Object object = ModuleSettingsKt.getKotlinFacet($this$kotlinCompilerSettings);
        if (object == null || (object = object.getSettings()) == null) {
            return defaultSettings;
        }
        Object facetSettings = object;
        if (((KotlinFacetSettings)facetSettings).getUseProjectSettings()) {
            return defaultSettings;
        }
        CompilerSettings compilerSettings = ((KotlinFacetSettings)facetSettings).getCompilerSettings();
        if (compilerSettings == null) {
            compilerSettings = defaultSettings;
        }
        return compilerSettings;
    }

    @NotNull
    public static final CommonCompilerArguments getKotlinCompilerArguments(@NotNull JpsModule $this$kotlinCompilerArguments) {
        CommonCompilerArguments commonCompilerArguments;
        Intrinsics.checkNotNullParameter((Object)$this$kotlinCompilerArguments, (String)"<this>");
        JpsModule $this$getCompilerArguments$iv = $this$kotlinCompilerArguments;
        boolean $i$f$getCompilerArguments = false;
        JpsProject jpsProject = $this$getCompilerArguments$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)jpsProject, (String)"project");
        CommonCompilerArguments projectSettings$iv = ProjectSettingsKt.getKotlinCompilerSettingsContainer(jpsProject).get$jps_plugin(CommonCompilerArguments.class);
        CommonCompilerArguments projectSettingsCopy$iv = ArgumentUtilsKt.copyBean(projectSettings$iv);
        Object object = ModuleSettingsKt.getKotlinFacet($this$getCompilerArguments$iv);
        if (object == null || (object = object.getSettings()) == null) {
            commonCompilerArguments = projectSettingsCopy$iv;
        } else {
            Object facetSettings$iv = object;
            if (((KotlinFacetSettings)facetSettings$iv).getUseProjectSettings()) {
                commonCompilerArguments = projectSettingsCopy$iv;
            } else {
                ((KotlinFacetSettings)facetSettings$iv).updateMergedArguments();
                CommonCompilerArguments commonCompilerArguments2 = ((KotlinFacetSettings)facetSettings$iv).getMergedCompilerArguments();
                if (!(commonCompilerArguments2 instanceof CommonCompilerArguments)) {
                    commonCompilerArguments2 = commonCompilerArguments = null;
                }
                if (commonCompilerArguments2 == null) {
                    commonCompilerArguments = projectSettingsCopy$iv;
                }
            }
        }
        return commonCompilerArguments;
    }

    @NotNull
    public static final K2MetadataCompilerArguments getK2MetadataCompilerArguments(@NotNull JpsModule $this$k2MetadataCompilerArguments) {
        CommonCompilerArguments commonCompilerArguments;
        Intrinsics.checkNotNullParameter((Object)$this$k2MetadataCompilerArguments, (String)"<this>");
        JpsModule $this$getCompilerArguments$iv = $this$k2MetadataCompilerArguments;
        boolean $i$f$getCompilerArguments = false;
        JpsProject jpsProject = $this$getCompilerArguments$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)jpsProject, (String)"project");
        K2MetadataCompilerArguments projectSettings$iv = ProjectSettingsKt.getKotlinCompilerSettingsContainer(jpsProject).get$jps_plugin(K2MetadataCompilerArguments.class);
        CommonCompilerArguments projectSettingsCopy$iv = ArgumentUtilsKt.copyBean(projectSettings$iv);
        Object object = ModuleSettingsKt.getKotlinFacet($this$getCompilerArguments$iv);
        if (object == null || (object = object.getSettings()) == null) {
            commonCompilerArguments = projectSettingsCopy$iv;
        } else {
            Object facetSettings$iv = object;
            if (((KotlinFacetSettings)facetSettings$iv).getUseProjectSettings()) {
                commonCompilerArguments = projectSettingsCopy$iv;
            } else {
                ((KotlinFacetSettings)facetSettings$iv).updateMergedArguments();
                CommonCompilerArguments commonCompilerArguments2 = ((KotlinFacetSettings)facetSettings$iv).getMergedCompilerArguments();
                if (!(commonCompilerArguments2 instanceof K2MetadataCompilerArguments)) {
                    commonCompilerArguments2 = null;
                }
                if ((commonCompilerArguments = (CommonCompilerArguments)((K2MetadataCompilerArguments)commonCompilerArguments2)) == null) {
                    commonCompilerArguments = projectSettingsCopy$iv;
                }
            }
        }
        return (K2MetadataCompilerArguments)commonCompilerArguments;
    }

    @NotNull
    public static final K2JSCompilerArguments getK2JsCompilerArguments(@NotNull JpsModule $this$k2JsCompilerArguments) {
        CommonCompilerArguments commonCompilerArguments;
        Intrinsics.checkNotNullParameter((Object)$this$k2JsCompilerArguments, (String)"<this>");
        JpsModule $this$getCompilerArguments$iv = $this$k2JsCompilerArguments;
        boolean $i$f$getCompilerArguments = false;
        JpsProject jpsProject = $this$getCompilerArguments$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)jpsProject, (String)"project");
        K2JSCompilerArguments projectSettings$iv = ProjectSettingsKt.getKotlinCompilerSettingsContainer(jpsProject).get$jps_plugin(K2JSCompilerArguments.class);
        CommonCompilerArguments projectSettingsCopy$iv = ArgumentUtilsKt.copyBean(projectSettings$iv);
        Object object = ModuleSettingsKt.getKotlinFacet($this$getCompilerArguments$iv);
        if (object == null || (object = object.getSettings()) == null) {
            commonCompilerArguments = projectSettingsCopy$iv;
        } else {
            Object facetSettings$iv = object;
            if (((KotlinFacetSettings)facetSettings$iv).getUseProjectSettings()) {
                commonCompilerArguments = projectSettingsCopy$iv;
            } else {
                ((KotlinFacetSettings)facetSettings$iv).updateMergedArguments();
                CommonCompilerArguments commonCompilerArguments2 = ((KotlinFacetSettings)facetSettings$iv).getMergedCompilerArguments();
                if (!(commonCompilerArguments2 instanceof K2JSCompilerArguments)) {
                    commonCompilerArguments2 = null;
                }
                if ((commonCompilerArguments = (CommonCompilerArguments)((K2JSCompilerArguments)commonCompilerArguments2)) == null) {
                    commonCompilerArguments = projectSettingsCopy$iv;
                }
            }
        }
        return (K2JSCompilerArguments)commonCompilerArguments;
    }

    @NotNull
    public static final K2JVMCompilerArguments getK2JvmCompilerArguments(@NotNull JpsModule $this$k2JvmCompilerArguments) {
        CommonCompilerArguments commonCompilerArguments;
        Intrinsics.checkNotNullParameter((Object)$this$k2JvmCompilerArguments, (String)"<this>");
        JpsModule $this$getCompilerArguments$iv = $this$k2JvmCompilerArguments;
        boolean $i$f$getCompilerArguments = false;
        JpsProject jpsProject = $this$getCompilerArguments$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)jpsProject, (String)"project");
        K2JVMCompilerArguments projectSettings$iv = ProjectSettingsKt.getKotlinCompilerSettingsContainer(jpsProject).get$jps_plugin(K2JVMCompilerArguments.class);
        CommonCompilerArguments projectSettingsCopy$iv = ArgumentUtilsKt.copyBean(projectSettings$iv);
        Object object = ModuleSettingsKt.getKotlinFacet($this$getCompilerArguments$iv);
        if (object == null || (object = object.getSettings()) == null) {
            commonCompilerArguments = projectSettingsCopy$iv;
        } else {
            Object facetSettings$iv = object;
            if (((KotlinFacetSettings)facetSettings$iv).getUseProjectSettings()) {
                commonCompilerArguments = projectSettingsCopy$iv;
            } else {
                ((KotlinFacetSettings)facetSettings$iv).updateMergedArguments();
                CommonCompilerArguments commonCompilerArguments2 = ((KotlinFacetSettings)facetSettings$iv).getMergedCompilerArguments();
                if (!(commonCompilerArguments2 instanceof K2JVMCompilerArguments)) {
                    commonCompilerArguments2 = null;
                }
                if ((commonCompilerArguments = (CommonCompilerArguments)((K2JVMCompilerArguments)commonCompilerArguments2)) == null) {
                    commonCompilerArguments = projectSettingsCopy$iv;
                }
            }
        }
        return (K2JVMCompilerArguments)commonCompilerArguments;
    }

    private static final /* synthetic */ <T extends CommonCompilerArguments> T getCompilerArguments(JpsModule $this$getCompilerArguments) {
        boolean $i$f$getCompilerArguments = false;
        JpsProject jpsProject = $this$getCompilerArguments.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)jpsProject, (String)"project");
        JpsKotlinCompilerSettings jpsKotlinCompilerSettings = ProjectSettingsKt.getKotlinCompilerSettingsContainer(jpsProject);
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        CommonCompilerArguments projectSettings = jpsKotlinCompilerSettings.get$jps_plugin(CommonCompilerArguments.class);
        CommonCompilerArguments projectSettingsCopy = ArgumentUtilsKt.copyBean(projectSettings);
        Object object = ModuleSettingsKt.getKotlinFacet($this$getCompilerArguments);
        if (object == null || (object = object.getSettings()) == null) {
            return (T)projectSettingsCopy;
        }
        Object facetSettings = object;
        if (((KotlinFacetSettings)facetSettings).getUseProjectSettings()) {
            return (T)projectSettingsCopy;
        }
        ((KotlinFacetSettings)facetSettings).updateMergedArguments();
        CommonCompilerArguments commonCompilerArguments = ((KotlinFacetSettings)facetSettings).getMergedCompilerArguments();
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)(commonCompilerArguments != null ? commonCompilerArguments : projectSettingsCopy);
    }

    private static final void findDependencies$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

