/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.KVisibility;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.Argument;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.InternalArgument;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.idea.ExplicitDefaultSubstitutor;
import org.jetbrains.kotlin.idea.ExplicitDefaultSubstitutorsKt;
import org.jetbrains.kotlin.utils.StringsKt;

public class ArgumentUtils {
    private ArgumentUtils() {
    }

    @NotNull
    public static List<String> convertArgumentsToStringList(@NotNull CommonToolArguments arguments2) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        KClass argumentsKClass;
        if (arguments2 == null) {
            ArgumentUtils.$$$reportNull$$$0(0);
        }
        List<String> convertedArguments = ArgumentUtils.convertArgumentsToStringListInternal(arguments2);
        Map<KClass<? extends CommonToolArguments>, Collection<ExplicitDefaultSubstitutor>> defaultSubstitutorsMap = ExplicitDefaultSubstitutorsKt.getDefaultSubstitutors();
        Collection<ExplicitDefaultSubstitutor> defaultSubstitutors = defaultSubstitutorsMap.get(argumentsKClass = JvmClassMappingKt.getKotlinClass(arguments2.getClass()));
        if (defaultSubstitutors != null) {
            for (ExplicitDefaultSubstitutor substitutor2 : defaultSubstitutors) {
                if (!substitutor2.isSubstitutable(convertedArguments)) continue;
                convertedArguments.addAll(substitutor2.getNewSubstitution());
            }
        }
        List<String> list = convertedArguments;
        if (list == null) {
            ArgumentUtils.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static List<String> convertArgumentsToStringListNoDefaults(@NotNull CommonToolArguments arguments2) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (arguments2 == null) {
            ArgumentUtils.$$$reportNull$$$0(2);
        }
        List<String> list = ArgumentUtils.convertArgumentsToStringListInternal(arguments2);
        if (list == null) {
            ArgumentUtils.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static List<String> convertArgumentsToStringListInternal(@NotNull CommonToolArguments arguments2) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (arguments2 == null) {
            ArgumentUtils.$$$reportNull$$$0(4);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        Class<?> argumentsClass = arguments2.getClass();
        ArgumentUtils.convertArgumentsToStringList(arguments2, (CommonToolArguments)argumentsClass.newInstance(), JvmClassMappingKt.getKotlinClass(argumentsClass), result2);
        result2.addAll(arguments2.getFreeArgs());
        result2.addAll(CollectionsKt.map(arguments2.getInternalArguments(), InternalArgument::getStringRepresentation));
        return result2;
    }

    private static void convertArgumentsToStringList(@NotNull CommonToolArguments arguments2, @NotNull CommonToolArguments defaultArguments, @NotNull KClass<?> clazz, @NotNull List<String> result2) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        if (arguments2 == null) {
            ArgumentUtils.$$$reportNull$$$0(5);
        }
        if (defaultArguments == null) {
            ArgumentUtils.$$$reportNull$$$0(6);
        }
        if (clazz == null) {
            ArgumentUtils.$$$reportNull$$$0(7);
        }
        if (result2 == null) {
            ArgumentUtils.$$$reportNull$$$0(8);
        }
        for (KProperty1<?, ?> property : KClasses.getMemberProperties(clazz)) {
            Argument argument2 = ArgumentUtils.findInstance(property.getAnnotations(), Argument.class);
            if (argument2 == null || property.getVisibility() != KVisibility.PUBLIC) continue;
            Object value2 = property.get((Object)arguments2);
            Object defaultValue = property.get((Object)defaultArguments);
            if (value2 == null || Objects.equals(value2, defaultValue)) continue;
            Type propertyJavaType = ReflectJvmMapping.getJavaType(property.getReturnType());
            if (propertyJavaType instanceof Class && ((Class)propertyJavaType).isArray()) {
                Object[] values = (Object[])value2;
                if (values.length == 0) continue;
                value2 = StringsKt.join(Arrays.asList(values), ",");
            }
            result2.add(argument2.value());
            if (propertyJavaType == Boolean.TYPE || propertyJavaType == Boolean.class) continue;
            if (ParseCommandLineArgumentsKt.isAdvanced(argument2)) {
                result2.set(result2.size() - 1, argument2.value() + "=" + value2.toString());
                continue;
            }
            result2.add(value2.toString());
        }
    }

    @Nullable
    private static <T> T findInstance(Iterable<? super T> iterable, Class<T> clazz) {
        for (T item : iterable) {
            if (!clazz.isInstance(item)) continue;
            return clazz.cast(item);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/compilerRunner/ArgumentUtils";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultArguments";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/compilerRunner/ArgumentUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "convertArgumentsToStringList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "convertArgumentsToStringListNoDefaults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertArgumentsToStringList";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertArgumentsToStringListNoDefaults";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertArgumentsToStringListInternal";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

