/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.util.ArrayList;
import java.util.List;
import net.rubygrapefruit.platform.MissingRegistryEntryException;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.WindowsRegistry;
import net.rubygrapefruit.platform.internal.FunctionResult;
import net.rubygrapefruit.platform.internal.jni.WindowsRegistryFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWindowsRegistry
implements WindowsRegistry {
    @Override
    public String getStringValue(WindowsRegistry.Key key, String subkey, String valueName) throws NativeException {
        FunctionResult result2 = new FunctionResult();
        String value2 = WindowsRegistryFunctions.getStringValue(key.ordinal(), subkey, valueName, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not get value '%s' of registry key '%s\\%s': %s", new Object[]{valueName, key, subkey, result2.getMessage()}));
        }
        if (value2 == null) {
            throw new MissingRegistryEntryException(String.format("Could not get value '%s' of registry key '%s\\%s' as it does not exist.", new Object[]{valueName, key, subkey}));
        }
        return value2;
    }

    @Override
    public List<String> getSubkeys(WindowsRegistry.Key key, String subkey) throws NativeException {
        FunctionResult result2 = new FunctionResult();
        ArrayList<String> subkeys = new ArrayList<String>();
        boolean found = WindowsRegistryFunctions.getSubkeys(key.ordinal(), subkey, subkeys, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not list the subkeys of registry key '%s\\%s': %s", new Object[]{key, subkey, result2.getMessage()}));
        }
        if (!found) {
            throw new MissingRegistryEntryException(String.format("Could not list the subkeys of registry key '%s\\%s' as it does not exist.", new Object[]{key, subkey}));
        }
        return subkeys;
    }

    @Override
    public List<String> getValueNames(WindowsRegistry.Key key, String subkey) throws NativeException {
        FunctionResult result2 = new FunctionResult();
        ArrayList<String> names = new ArrayList<String>();
        boolean found = WindowsRegistryFunctions.getValueNames(key.ordinal(), subkey, names, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not list the values of registry key '%s\\%s': %s", new Object[]{key, subkey, result2.getMessage()}));
        }
        if (!found) {
            throw new MissingRegistryEntryException(String.format("Could not list the values of registry key '%s\\%s' as it does not exist.", new Object[]{key, subkey}));
        }
        return names;
    }
}

