/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.Name;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpecialNames {
    @NotNull
    public static final SpecialNames INSTANCE = new SpecialNames();
    @JvmField
    @NotNull
    public static final Name NO_NAME_PROVIDED;
    @JvmField
    @NotNull
    public static final Name ROOT_PACKAGE;
    @JvmField
    @NotNull
    public static final Name DEFAULT_NAME_FOR_COMPANION_OBJECT;
    @JvmField
    @NotNull
    public static final Name SAFE_IDENTIFIER_FOR_NO_NAME;
    @JvmField
    @NotNull
    public static final Name ANONYMOUS;
    @JvmField
    @NotNull
    public static final Name UNARY;
    @JvmField
    @NotNull
    public static final Name THIS;
    @JvmField
    @NotNull
    public static final Name INIT;
    @JvmField
    @NotNull
    public static final Name ITERATOR;
    @JvmField
    @NotNull
    public static final Name DESTRUCT;
    @JvmField
    @NotNull
    public static final Name LOCAL;
    @JvmField
    @NotNull
    public static final Name UNDERSCORE_FOR_UNUSED_VAR;

    private SpecialNames() {
    }

    @JvmStatic
    @NotNull
    public static final Name safeIdentifier(@Nullable Name name) {
        return name != null && !name.isSpecial() ? name : SAFE_IDENTIFIER_FOR_NO_NAME;
    }

    public final boolean isSafeIdentifier(@NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string2 = name.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name.asString()");
        return ((CharSequence)string2).length() > 0 && !name.isSpecial();
    }

    static {
        Name name = Name.special("<no name provided>");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"special(\"<no name provided>\")");
        NO_NAME_PROVIDED = name;
        name = Name.special("<root package>");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"special(\"<root package>\")");
        ROOT_PACKAGE = name;
        name = Name.identifier("Companion");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"Companion\")");
        DEFAULT_NAME_FOR_COMPANION_OBJECT = name;
        name = Name.identifier("no_name_in_PSI_3d19d79d_1ba9_4cd0_b7f5_b46aa3cd5d40");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"no_name_in_P\u2026_4cd0_b7f5_b46aa3cd5d40\")");
        SAFE_IDENTIFIER_FOR_NO_NAME = name;
        name = Name.special("<anonymous>");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"special(ANONYMOUS_STRING)");
        ANONYMOUS = name;
        name = Name.special("<unary>");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"special(\"<unary>\")");
        UNARY = name;
        name = Name.special("<this>");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"special(\"<this>\")");
        THIS = name;
        name = Name.special("<init>");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"special(\"<init>\")");
        INIT = name;
        name = Name.special("<iterator>");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"special(\"<iterator>\")");
        ITERATOR = name;
        name = Name.special("<destruct>");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"special(\"<destruct>\")");
        DESTRUCT = name;
        name = Name.special("<local>");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"special(\"<local>\")");
        LOCAL = name;
        name = Name.special("<unused var>");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"special(\"<unused var>\")");
        UNDERSCORE_FOR_UNUSED_VAR = name;
    }
}

