/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.Java16SealedRecordLoader;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotation;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationOwner;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClassifierType;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaConstructor;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaElement;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaField;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaMethod;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaModifierListOwner;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaRecordComponent;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaTypeParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifierType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaRecordComponent;
import kotlin.reflect.jvm.internal.impl.load.java.structure.LightClassOriginKind;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectJavaClass
extends ReflectJavaElement
implements ReflectJavaAnnotationOwner,
ReflectJavaModifierListOwner,
JavaClass {
    @NotNull
    private final Class<?> klass;

    public ReflectJavaClass(@NotNull Class<?> klass) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        this.klass = klass;
    }

    @Override
    @NotNull
    public Class<?> getElement() {
        return this.klass;
    }

    @Override
    public int getModifiers() {
        return this.klass.getModifiers();
    }

    @NotNull
    public List<Name> getInnerClassNames() {
        Class<?>[] classArray = this.klass.getDeclaredClasses();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"klass.declaredClasses");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)ArraysKt.asSequence((Object[])classArray), (Function1)innerClassNames.1.INSTANCE), (Function1)innerClassNames.2.INSTANCE));
    }

    @Override
    @NotNull
    public FqName getFqName() {
        FqName fqName2 = ReflectClassUtilKt.getClassId(this.klass).asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"klass.classId.asSingleFqName()");
        return fqName2;
    }

    @Override
    @Nullable
    public ReflectJavaClass getOuterClass() {
        ReflectJavaClass reflectJavaClass;
        Class<?> clazz = this.klass.getDeclaringClass();
        if (clazz == null) {
            reflectJavaClass = null;
        } else {
            Class<?> clazz2;
            Class<?> p0 = clazz2 = clazz;
            boolean bl = false;
            reflectJavaClass = new ReflectJavaClass(p0);
        }
        return reflectJavaClass;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<JavaClassifierType> getSupertypes() {
        void $this$mapTo$iv$iv;
        if (Intrinsics.areEqual(this.klass, Object.class)) {
            return CollectionsKt.emptyList();
        }
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        Type[] typeArray = this.klass.getGenericSuperclass();
        spreadBuilder.add(typeArray == null ? (Type)((Object)Object.class) : typeArray);
        typeArray = this.klass.getGenericInterfaces();
        Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"klass.genericInterfaces");
        spreadBuilder.addSpread((Object)typeArray);
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new Type[spreadBuilder.size()]));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Type type2 = (Type)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ReflectJavaClassifierType reflectJavaClassifierType = new ReflectJavaClassifierType((Type)p0);
            collection.add(reflectJavaClassifierType);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public List<ReflectJavaMethod> getMethods() {
        Method[] methodArray = this.klass.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"klass.declaredMethods");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])methodArray), (Function1)((Function1)new Function1<Method, Boolean>(this){
            final /* synthetic */ ReflectJavaClass this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Method method) {
                boolean bl;
                if (method.isSynthetic()) {
                    bl = false;
                } else if (this.this$0.isEnum()) {
                    Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
                    bl = !ReflectJavaClass.access$isEnumValuesOrValueOf(this.this$0, method);
                } else {
                    bl = true;
                }
                return bl;
            }
        })), (Function1)methods.2.INSTANCE));
    }

    private final boolean isEnumValuesOrValueOf(Method method) {
        boolean bl;
        String string2 = method.getName();
        if (Intrinsics.areEqual((Object)string2, (Object)"values")) {
            Class<?>[] classArray = method.getParameterTypes();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"method.parameterTypes");
            bl = ((Object[])classArray).length == 0;
        } else if (Intrinsics.areEqual((Object)string2, (Object)"valueOf")) {
            Object[] objectArray = new Class[]{String.class};
            bl = Arrays.equals(method.getParameterTypes(), objectArray);
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public List<ReflectJavaField> getFields() {
        Field[] fieldArray = this.klass.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"klass.declaredFields");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)ArraysKt.asSequence((Object[])fieldArray), (Function1)fields.1.INSTANCE), (Function1)fields.2.INSTANCE));
    }

    @NotNull
    public List<ReflectJavaConstructor> getConstructors() {
        Constructor<?>[] constructorArray = this.klass.getDeclaredConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"klass.declaredConstructors");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)ArraysKt.asSequence((Object[])constructorArray), (Function1)constructors.1.INSTANCE), (Function1)constructors.2.INSTANCE));
    }

    @Override
    public boolean hasDefaultConstructor() {
        return false;
    }

    @Override
    @Nullable
    public LightClassOriginKind getLightClassOriginKind() {
        return null;
    }

    @Override
    @NotNull
    public Name getName() {
        Name name = Name.identifier(this.klass.getSimpleName());
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(klass.simpleName)");
        return name;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ReflectJavaTypeParameter> getTypeParameters() {
        void $this$mapTo$iv$iv;
        TypeVariable<Class<?>>[] typeVariableArray = this.klass.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(typeVariableArray, (String)"klass.typeParameters");
        Object[] $this$map$iv = typeVariableArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            TypeVariable typeVariable = (TypeVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ReflectJavaTypeParameter reflectJavaTypeParameter = new ReflectJavaTypeParameter((TypeVariable<?>)p0);
            collection.add(reflectJavaTypeParameter);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean isInterface() {
        return this.klass.isInterface();
    }

    @Override
    public boolean isAnnotationType() {
        return this.klass.isAnnotation();
    }

    @Override
    public boolean isEnum() {
        return this.klass.isEnum();
    }

    @Override
    public boolean isRecord() {
        Boolean bl = Java16SealedRecordLoader.INSTANCE.loadIsRecord(this.klass);
        return bl == null ? false : bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<JavaRecordComponent> getRecordComponents() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object[] objectArray;
        Object[] objectArray2 = Java16SealedRecordLoader.INSTANCE.loadGetRecordComponents(this.klass);
        if (objectArray2 == null) {
            boolean $i$f$emptyArray = false;
            objectArray = new Object[]{};
        } else {
            objectArray = $this$map$iv;
        }
        $this$map$iv = objectArray;
        boolean $i$f$map = false;
        void var3_3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            void var10_10 = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ReflectJavaRecordComponent reflectJavaRecordComponent = new ReflectJavaRecordComponent(p0);
            collection.add(reflectJavaRecordComponent);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean isSealed() {
        Boolean bl = Java16SealedRecordLoader.INSTANCE.loadIsSealed(this.klass);
        return bl == null ? false : bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<JavaClassifierType> getPermittedTypes() {
        Collection collection;
        Class<?>[] classArray = Java16SealedRecordLoader.INSTANCE.loadGetPermittedSubclasses(this.klass);
        if (classArray == null) {
            collection = CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            Class<?>[] $this$map$iv = classArray;
            boolean $i$f$map = false;
            Class<?>[] classArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                Type type2 = (Type)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                ReflectJavaClassifierType reflectJavaClassifierType = new ReflectJavaClassifierType((Type)p0);
                collection2.add(reflectJavaClassifierType);
            }
            collection = (List)destination$iv$iv;
        }
        return collection;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ReflectJavaClass && Intrinsics.areEqual(this.klass, ((ReflectJavaClass)other).klass);
    }

    public int hashCode() {
        return this.klass.hashCode();
    }

    @NotNull
    public String toString() {
        return this.getClass().getName() + ": " + this.klass;
    }

    @Override
    @Nullable
    public ReflectJavaAnnotation findAnnotation(@NotNull FqName fqName2) {
        return ReflectJavaAnnotationOwner.DefaultImpls.findAnnotation(this, fqName2);
    }

    @NotNull
    public List<ReflectJavaAnnotation> getAnnotations() {
        return ReflectJavaAnnotationOwner.DefaultImpls.getAnnotations(this);
    }

    @Override
    public boolean isAbstract() {
        return ReflectJavaModifierListOwner.DefaultImpls.isAbstract(this);
    }

    @Override
    public boolean isDeprecatedInJavaDoc() {
        return ReflectJavaAnnotationOwner.DefaultImpls.isDeprecatedInJavaDoc(this);
    }

    @Override
    public boolean isFinal() {
        return ReflectJavaModifierListOwner.DefaultImpls.isFinal(this);
    }

    @Override
    public boolean isStatic() {
        return ReflectJavaModifierListOwner.DefaultImpls.isStatic(this);
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return ReflectJavaModifierListOwner.DefaultImpls.getVisibility(this);
    }

    public static final /* synthetic */ boolean access$isEnumValuesOrValueOf(ReflectJavaClass $this, Method method) {
        return $this.isEnumValuesOrValueOf(method);
    }
}

