/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.ui;

import com.android.tools.idea.insights.AppInsightsProjectLevelController;
import com.android.tools.idea.insights.Note;
import com.android.tools.idea.insights.NoteState;
import com.android.tools.idea.insights.Permission;
import com.google.services.firebase.insights.ui.AppInsightsNotesView;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/google/services/firebase/insights/ui/DeleteNoteAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "checkEnable", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "firebase"})
public final class DeleteNoteAction
extends AnAction {
    @NotNull
    public static final DeleteNoteAction INSTANCE = new DeleteNoteAction();

    private DeleteNoteAction() {
        super("Delete Note");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Note note = (Note)e.getDataContext().getData(AppInsightsNotesView.Companion.getSELECTED_NOTE());
            if (note == null) {
                return;
            }
            Note note2 = note;
            AppInsightsProjectLevelController appInsightsProjectLevelController = (AppInsightsProjectLevelController)e.getDataContext().getData(AppInsightsNotesView.Companion.getMODULE_CONTROLLER());
            if (appInsightsProjectLevelController == null) break block1;
            appInsightsProjectLevelController.deleteNote(note2);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"e.dataContext");
        presentation.setEnabled(this.checkEnable(dataContext));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkEnable(DataContext dataContext) {
        if (dataContext.getData(AppInsightsNotesView.Companion.getFIREBASE_ACCESS_PERMISSION()) != Permission.FULL) return false;
        Note note = (Note)dataContext.getData(AppInsightsNotesView.Companion.getSELECTED_NOTE());
        if ((note != null ? note.getState() : null) != NoteState.CREATED) return false;
        return true;
    }
}

