/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.ui;

import com.android.tools.idea.concurrency.AndroidDispatchers;
import com.android.tools.idea.concurrency.CoroutinesUtilsKt;
import com.android.tools.idea.insights.AppInsightsModel;
import com.android.tools.idea.insights.AppInsightsProjectLevelController;
import com.android.tools.idea.insights.analytics.AppInsightsTracker;
import com.android.tools.idea.insights.ui.AppInsightsTabPanel;
import com.android.tools.idea.insights.ui.AppInsightsTabProvider;
import com.google.services.firebase.insights.CrashlyticsConfigurationManager;
import com.google.services.firebase.insights.ui.AppInsightsTab;
import com.google.services.firebase.insights.ui.CrashlyticsTabProvider;
import com.google.wireless.android.sdk.stats.AppQualityInsightsUsageEvent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.StatusText;
import icons.FirebaseIcons;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.time.Clock;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0002J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/google/services/firebase/insights/ui/CrashlyticsTabProvider;", "Lcom/android/tools/idea/insights/ui/AppInsightsTabProvider;", "()V", "tabDisplayName", "", "getTabDisplayName", "()Ljava/lang/String;", "tabIcon", "Ljavax/swing/Icon;", "getTabIcon", "()Ljavax/swing/Icon;", "loggedOutErrorStateComponent", "Ljavax/swing/JPanel;", "placeholderContent", "populateTab", "", "tabShell", "Lcom/android/tools/idea/insights/ui/AppInsightsTabPanel;", "controller", "Lcom/android/tools/idea/insights/AppInsightsProjectLevelController;", "project", "Lcom/intellij/openapi/project/Project;", "tracker", "Lcom/android/tools/idea/insights/analytics/AppInsightsTracker;", "tabPanel", "firebase"})
@SourceDebugExtension(value={"SMAP\nCrashlyticsTabProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrashlyticsTabProvider.kt\ncom/google/services/firebase/insights/ui/CrashlyticsTabProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,164:1\n29#2,3:165\n29#2,3:168\n*S KotlinDebug\n*F\n+ 1 CrashlyticsTabProvider.kt\ncom/google/services/firebase/insights/ui/CrashlyticsTabProvider\n*L\n51#1:165,3\n52#1:168,3\n*E\n"})
public final class CrashlyticsTabProvider
implements AppInsightsTabProvider {
    @NotNull
    private final String tabDisplayName;
    @NotNull
    private final Icon tabIcon;

    public CrashlyticsTabProvider() {
        this.tabDisplayName = "Firebase Crashlytics";
        Icon icon = FirebaseIcons.ACTION_ICON;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ACTION_ICON");
        this.tabIcon = icon;
    }

    @NotNull
    public String getTabDisplayName() {
        return this.tabDisplayName;
    }

    @NotNull
    public Icon getTabIcon() {
        return this.tabIcon;
    }

    public void populateTab(@NotNull Project project, @NotNull AppInsightsTabPanel tabPanel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tabPanel, (String)"tabPanel");
        PropertiesComponent.getInstance((Project)project).setValue("com.google.services.firebase.aqiPopupShown", true);
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<CrashlyticsConfigurationManager> serviceClass$iv = CrashlyticsConfigurationManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        CrashlyticsConfigurationManager insightsService = (CrashlyticsConfigurationManager)object;
        ComponentManager $this$service$iv2 = (ComponentManager)project;
        boolean $i$f$service2 = false;
        Class<AppInsightsTracker> serviceClass$iv2 = AppInsightsTracker.class;
        Object object2 = $this$service$iv2.getService(serviceClass$iv2);
        if (object2 == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv2.getName() + " in " + $this$service$iv2 + " (classloader=" + serviceClass$iv2.getClassLoader()).toString());
        }
        AppInsightsTracker tracker = (AppInsightsTracker)object2;
        tabPanel.setComponent((JComponent)this.placeholderContent());
        Unit placeholderContent2 = Unit.INSTANCE;
        BuildersKt.launch$default((CoroutineScope)CoroutinesUtilsKt.AndroidCoroutineScope$default((Disposable)((Disposable)tabPanel), null, (int)2, null), (CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(insightsService, tabPanel, this, tracker, project, null){
            int label;
            final /* synthetic */ CrashlyticsConfigurationManager $insightsService;
            final /* synthetic */ AppInsightsTabPanel $tabPanel;
            final /* synthetic */ CrashlyticsTabProvider this$0;
            final /* synthetic */ AppInsightsTracker $tracker;
            final /* synthetic */ Project $project;
            {
                this.$insightsService = $insightsService;
                this.$tabPanel = $tabPanel;
                this.this$0 = $receiver;
                this.$tracker = $tracker;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Ref.BooleanRef isLoggedIn = new Ref.BooleanRef();
                        isLoggedIn.element = true;
                        this.label = 1;
                        Object object3 = this.$insightsService.getConfiguration().collect(new FlowCollector(isLoggedIn, this.$tabPanel, this.this$0, this.$tracker, this.$project){
                            final /* synthetic */ Ref.BooleanRef $isLoggedIn;
                            final /* synthetic */ AppInsightsTabPanel $tabPanel;
                            final /* synthetic */ CrashlyticsTabProvider this$0;
                            final /* synthetic */ AppInsightsTracker $tracker;
                            final /* synthetic */ Project $project;
                            {
                                this.$isLoggedIn = $isLoggedIn;
                                this.$tabPanel = $tabPanel;
                                this.this$0 = $receiver;
                                this.$tracker = $tracker;
                                this.$project = $project;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Nullable
                            public final Object emit(@NotNull AppInsightsModel appInsightsModel, @NotNull Continuation<? super Unit> $completion) {
                                AppInsightsModel appInsightsModel2 = appInsightsModel;
                                if (Intrinsics.areEqual((Object)appInsightsModel2, (Object)AppInsightsModel.Unauthenticated.INSTANCE)) {
                                    if (this.$isLoggedIn.element) {
                                        void $this$emit_u24lambda_u240;
                                        AppQualityInsightsUsageEvent.AppQualityInsightsZeroStateDetails.Builder builder;
                                        this.$tabPanel.setComponent((JComponent)CrashlyticsTabProvider.access$loggedOutErrorStateComponent(this.this$0));
                                        this.$isLoggedIn.element = false;
                                        AppQualityInsightsUsageEvent.AppQualityInsightsZeroStateDetails.Builder builder2 = builder = AppQualityInsightsUsageEvent.AppQualityInsightsZeroStateDetails.newBuilder();
                                        AppInsightsTracker appInsightsTracker = this.$tracker;
                                        boolean bl = false;
                                        $this$emit_u24lambda_u240.setEmptyState(AppQualityInsightsUsageEvent.AppQualityInsightsZeroStateDetails.EmptyState.NO_LOGIN);
                                        AppQualityInsightsUsageEvent.AppQualityInsightsZeroStateDetails appQualityInsightsZeroStateDetails = builder.build();
                                        Intrinsics.checkNotNullExpressionValue((Object)appQualityInsightsZeroStateDetails, (String)"newBuilder()\n           \u2026                 .build()");
                                        appInsightsTracker.logZeroState(appQualityInsightsZeroStateDetails);
                                    }
                                } else if (appInsightsModel2 instanceof AppInsightsModel.Authenticated) {
                                    if (!this.$isLoggedIn.element) {
                                        this.$isLoggedIn.element = true;
                                    }
                                    CrashlyticsTabProvider.access$populateTab(this.this$0, this.$tabPanel, ((AppInsightsModel.Authenticated)appInsightsModel).getController(), this.$project, this.$tracker);
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void populateTab(AppInsightsTabPanel tabShell, AppInsightsProjectLevelController controller, Project project, AppInsightsTracker tracker) {
        Clock clock = Clock.systemDefaultZone();
        Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"systemDefaultZone()");
        AppInsightsTab tab = new AppInsightsTab(controller, clock, project, tracker, (Disposable)tabShell);
        tabShell.setComponent((JComponent)tab);
    }

    private final JPanel placeholderContent() {
        return new JPanel(){
            @NotNull
            private final placeholderContent.text.1 text;
            {
                void it;
                StatusText statusText;
                StatusText statusText2 = statusText = new StatusText(){

                    protected boolean isStatusVisible() {
                        return true;
                    }
                };
                var var4_3 = this;
                boolean bl = false;
                it.appendLine("Waiting for initial sync...", SimpleTextAttributes.GRAYED_ATTRIBUTES, null);
                it.attachTo((Component)this);
                var4_3.text = statusText;
            }

            public void paint(@Nullable Graphics g) {
                super.paint(g);
                this.text.paint(this, g);
            }
        };
    }

    private final JPanel loggedOutErrorStateComponent() {
        StatusText statusText;
        StatusText $this$loggedOutErrorStateComponent_u24lambda_u240 = statusText = new StatusText(){

            protected boolean isStatusVisible() {
                return true;
            }
        };
        boolean bl = false;
        $this$loggedOutErrorStateComponent_u24lambda_u240.appendLine(FirebaseIcons.FIREBASE_LOGO, "", SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
        $this$loggedOutErrorStateComponent_u24lambda_u240.appendLine("See real-world app quality insights here", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES, null);
        $this$loggedOutErrorStateComponent_u24lambda_u240.appendLine("Log in", SimpleTextAttributes.LINK_ATTRIBUTES, (ActionListener)loggedOutErrorStateComponent.loggedOutText.2.1.INSTANCE);
        $this$loggedOutErrorStateComponent_u24lambda_u240.appendText(" to Android Studio to connect to your Firebase Account");
        $this$loggedOutErrorStateComponent_u24lambda_u240.appendLine("");
        $this$loggedOutErrorStateComponent_u24lambda_u240.appendLine(AllIcons.General.ContextHelp, "More Info", SimpleTextAttributes.LINK_ATTRIBUTES, (ActionListener)loggedOutErrorStateComponent.loggedOutText.2.2.INSTANCE);
        StatusText loggedOutText2 = statusText;
        return new JPanel(loggedOutText2){
            final /* synthetic */ loggedOutErrorStateComponent.loggedOutText.1 $loggedOutText;
            {
                this.$loggedOutText = $loggedOutText;
                $loggedOutText.attachTo(this);
            }

            public void paint(@Nullable Graphics g) {
                super.paint(g);
                this.$loggedOutText.paint(this, g);
            }
        };
    }

    public static final /* synthetic */ JPanel access$loggedOutErrorStateComponent(CrashlyticsTabProvider $this) {
        return $this.loggedOutErrorStateComponent();
    }

    public static final /* synthetic */ void access$populateTab(CrashlyticsTabProvider $this, AppInsightsTabPanel tabShell, AppInsightsProjectLevelController controller, Project project, AppInsightsTracker tracker) {
        $this.populateTab(tabShell, controller, project, tracker);
    }
}

