/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.datamodel;

import com.android.tools.idea.insights.FailureType;
import com.android.tools.idea.insights.IssueDetails;
import com.android.tools.idea.insights.IssueId;
import com.android.tools.idea.insights.IssueState;
import com.android.tools.idea.insights.SignalType;
import com.google.services.firebase.insights.datamodel.FatalityKt;
import com.google.services.firebase.insights.proto.ErrorType;
import com.google.services.firebase.insights.proto.IntervalMetrics;
import com.google.services.firebase.insights.proto.Issue;
import com.google.services.firebase.insights.proto.IssueSignals;
import com.google.services.firebase.insights.proto.ReportGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0000\u001a\u000e\u0010\u0003\u001a\u0004\u0018\u00010\u0006*\u00020\u0007H\u0000\u001a\u000e\u0010\b\u001a\u0004\u0018\u00010\u0007*\u00020\tH\u0000\u00a8\u0006\n"}, d2={"toIssueDetails", "Lcom/android/tools/idea/insights/IssueDetails;", "Lcom/google/services/firebase/insights/proto/ReportGroup;", "toProto", "Lcom/google/services/firebase/insights/proto/Issue$State;", "Lcom/android/tools/idea/insights/IssueState;", "Lcom/google/services/firebase/insights/proto/IssueSignals$Signal;", "Lcom/android/tools/idea/insights/SignalType;", "toSignalType", "Lcom/google/services/firebase/insights/proto/IssueSignals;", "firebase"})
@SourceDebugExtension(value={"SMAP\nIssues.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Issues.kt\ncom/google/services/firebase/insights/datamodel/IssuesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1603#2,9:70\n1851#2:79\n1852#2:81\n1612#2:82\n1#3:80\n*S KotlinDebug\n*F\n+ 1 Issues.kt\ncom/google/services/firebase/insights/datamodel/IssuesKt\n*L\n38#1:70,9\n38#1:79\n38#1:81\n38#1:82\n38#1:80\n*E\n"})
public final class IssuesKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IssueDetails toIssueDetails(@NotNull ReportGroup $this$toIssueDetails) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toIssueDetails, (String)"<this>");
        List list = $this$toIssueDetails.getMetricsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"metricsList");
        IntervalMetrics metrics = (IntervalMetrics)CollectionsKt.single((List)list);
        String string = $this$toIssueDetails.getIssue().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"issue.id");
        String string2 = IssueId.constructor-impl((String)string);
        String string3 = $this$toIssueDetails.getIssue().getTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"issue.title");
        String string4 = $this$toIssueDetails.getIssue().getSubtitle();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"issue.subtitle");
        ErrorType errorType = $this$toIssueDetails.getIssue().getErrorType();
        Intrinsics.checkNotNullExpressionValue((Object)errorType, (String)"issue.errorType");
        FailureType failureType = FatalityKt.toFatality(errorType);
        String string5 = $this$toIssueDetails.getIssue().getSampleEvent();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"issue.sampleEvent");
        String string6 = $this$toIssueDetails.getIssue().getFirstSeenVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"issue.firstSeenVersion");
        String string7 = $this$toIssueDetails.getIssue().getLastSeenVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"issue.lastSeenVersion");
        long l = metrics.getImpactedUsersCount().getValue();
        long l2 = metrics.getEventsCount().getValue();
        List list2 = $this$toIssueDetails.getIssue().getSignalsList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"issue.signalsList");
        Iterable iterable = list2;
        long l3 = l2;
        long l4 = l;
        String string8 = string7;
        String string9 = string6;
        String string10 = string5;
        FailureType failureType2 = failureType;
        String string11 = string4;
        String string12 = string3;
        String string13 = string2;
        boolean $i$f$mapNotNull = false;
        void var4_13 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            SignalType it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            IssueSignals it = (IssueSignals)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (IssuesKt.toSignalType(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        Set set = CollectionsKt.toSet((Iterable)list3);
        String string14 = $this$toIssueDetails.getIssue().getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"issue.uri");
        DefaultConstructorMarker defaultConstructorMarker = null;
        long l5 = $this$toIssueDetails.getIssue().getNotesCount();
        String string15 = string14;
        Set set2 = set;
        long l6 = l3;
        long l7 = l4;
        String string16 = string8;
        String string17 = string9;
        String string18 = string10;
        FailureType failureType3 = failureType2;
        String string19 = string11;
        String string20 = string12;
        String string21 = string13;
        return new IssueDetails(string21, string20, string19, failureType3, string18, string17, string16, l7, l6, set2, string15, l5, defaultConstructorMarker);
    }

    @NotNull
    public static final Issue.State toProto(@NotNull IssueState $this$toProto) {
        Intrinsics.checkNotNullParameter((Object)$this$toProto, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toProto.ordinal()]) {
            case 1 -> Issue.State.OPEN;
            case 2 -> Issue.State.CLOSED;
            default -> throw new IllegalStateException("Only `OPEN` or `CLOSED` is allowed.");
        };
    }

    @Nullable
    public static final IssueSignals.Signal toProto(@NotNull SignalType $this$toProto) {
        Intrinsics.checkNotNullParameter((Object)$this$toProto, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$1[$this$toProto.ordinal()]) {
            case 1 -> IssueSignals.Signal.SIGNAL_EARLY;
            case 2 -> IssueSignals.Signal.SIGNAL_FRESH;
            case 3 -> IssueSignals.Signal.SIGNAL_REGRESSED;
            case 4 -> IssueSignals.Signal.SIGNAL_REPETITIVE;
            case 5 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Nullable
    public static final SignalType toSignalType(@NotNull IssueSignals $this$toSignalType) {
        Intrinsics.checkNotNullParameter((Object)$this$toSignalType, (String)"<this>");
        IssueSignals.Signal signal = $this$toSignalType.getSignal();
        return switch (signal == null ? -1 : WhenMappings.$EnumSwitchMapping$2[signal.ordinal()]) {
            case 1 -> SignalType.SIGNAL_EARLY;
            case 2 -> SignalType.SIGNAL_FRESH;
            case 3 -> SignalType.SIGNAL_REGRESSED;
            case 4 -> SignalType.SIGNAL_REPETITIVE;
            default -> null;
        };
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[IssueState.values().length];
            try {
                nArray[IssueState.OPEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueState.CLOSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SignalType.values().length];
            try {
                nArray[SignalType.SIGNAL_EARLY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SignalType.SIGNAL_FRESH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SignalType.SIGNAL_REGRESSED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SignalType.SIGNAL_REPETITIVE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SignalType.SIGNAL_UNSPECIFIED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[IssueSignals.Signal.values().length];
            try {
                nArray[IssueSignals.Signal.SIGNAL_EARLY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueSignals.Signal.SIGNAL_FRESH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueSignals.Signal.SIGNAL_REGRESSED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueSignals.Signal.SIGNAL_REPETITIVE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

