/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.datamodel;

import com.android.tools.idea.insights.Blames;
import com.android.tools.idea.insights.Caption;
import com.android.tools.idea.insights.Device;
import com.android.tools.idea.insights.Event;
import com.android.tools.idea.insights.EventData;
import com.android.tools.idea.insights.ExceptionStack;
import com.android.tools.idea.insights.Frame;
import com.android.tools.idea.insights.OperatingSystemInfo;
import com.android.tools.idea.insights.Stacktrace;
import com.android.tools.idea.insights.StacktraceGroup;
import com.android.tools.idea.insights.Version;
import com.android.tools.idea.protobuf.Timestamp;
import com.google.services.firebase.insights.client.grpc.ProtobufUtilsKt;
import com.google.services.firebase.insights.datamodel.EventsKt;
import com.google.services.firebase.insights.proto.Event;
import com.google.services.firebase.insights.proto.Exception;
import com.google.services.firebase.insights.proto.Interval;
import com.google.services.firebase.insights.proto.OperatingSystem;
import com.google.services.firebase.insights.proto.PlayTrack;
import com.google.services.firebase.insights.proto.TrackType;
import com.google.services.firebase.insights.proto.Version;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0004\u001a\u00020\u0007H\u0000\u001a\u0016\u0010\u0002\u001a\u00020\b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0000\u001a\u0014\u0010\u0002\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0004\u001a\u00020\rH\u0000\u001a\u0014\u0010\u0002\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0010H\u0000\u001a\u0014\u0010\u0002\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0013H\u0000\u001a\u0014\u0010\u0002\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0016H\u0000\u001a\n\u0010\u0017\u001a\u00020\u0018*\u00020\u0019\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"trampolineFrameRegex", "Lkotlin/text/Regex;", "fromProto", "Lcom/android/tools/idea/insights/Frame;", "proto", "Lcom/google/services/firebase/insights/proto/Frame;", "Lcom/android/tools/idea/insights/PlayTrack;", "Lcom/google/services/firebase/insights/proto/PlayTrack;", "Lcom/android/tools/idea/insights/StacktraceGroup;", "", "Lcom/google/services/firebase/insights/proto/Exception;", "Lcom/android/tools/idea/insights/Device;", "Lcom/android/tools/idea/insights/Device$Companion;", "Lcom/google/services/firebase/insights/proto/Device;", "Lcom/android/tools/idea/insights/Event;", "Lcom/android/tools/idea/insights/Event$Companion;", "Lcom/google/services/firebase/insights/proto/Event;", "Lcom/android/tools/idea/insights/OperatingSystemInfo;", "Lcom/android/tools/idea/insights/OperatingSystemInfo$Companion;", "Lcom/google/services/firebase/insights/proto/OperatingSystem;", "Lcom/android/tools/idea/insights/Version;", "Lcom/android/tools/idea/insights/Version$Companion;", "Lcom/google/services/firebase/insights/proto/Version;", "toProto", "Lcom/google/services/firebase/insights/proto/Interval;", "Lcom/android/tools/idea/insights/client/Interval;", "firebase"})
@SourceDebugExtension(value={"SMAP\nEvents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Events.kt\ncom/google/services/firebase/insights/datamodel/EventsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1549#2:129\n1620#2,2:130\n1549#2:132\n1620#2,3:133\n766#2:136\n857#2,2:137\n1622#2:139\n*S KotlinDebug\n*F\n+ 1 Events.kt\ncom/google/services/firebase/insights/datamodel/EventsKt\n*L\n61#1:129\n61#1:130,2\n69#1:132\n69#1:133,3\n70#1:136\n70#1:137,2\n61#1:139\n*E\n"})
public final class EventsKt {
    @NotNull
    private static final Regex trampolineFrameRegex = new Regex(".+\\.access\\$\\d+00");

    @NotNull
    public static final Interval toProto(@NotNull com.android.tools.idea.insights.client.Interval $this$toProto) {
        Interval.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$toProto, (String)"<this>");
        Interval.Builder $this$toProto_u24lambda_u240 = builder = Interval.newBuilder();
        boolean bl = false;
        $this$toProto_u24lambda_u240.setStartTime(ProtobufUtilsKt.toProtoTimestamp($this$toProto.getStartTime()));
        $this$toProto_u24lambda_u240.setEndTime(ProtobufUtilsKt.toProtoTimestamp($this$toProto.getEndTime()));
        Interval interval = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)interval, (String)"newBuilder()\n    .apply \u2026tamp()\n    }\n    .build()");
        return interval;
    }

    @NotNull
    public static final Frame fromProto(@NotNull com.google.services.firebase.insights.proto.Frame proto) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        long l = proto.getLine();
        String string = proto.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"proto.file");
        String string2 = proto.getSymbol();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"proto.symbol");
        long l2 = proto.getOffset();
        long l3 = proto.getAddress();
        String string3 = proto.getLibrary();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"proto.library");
        return new Frame(l, string, string2, l2, l3, string3, proto.getBlamed() ? Blames.BLAMED : Blames.NOT_BLAMED);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final StacktraceGroup fromProto(@NotNull List<Exception> proto) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(proto, (String)"proto");
        Iterable $this$map$iv = proto;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            String string2;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Frame it;
            Collection<Frame> collection;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2;
            void exception;
            Exception exception2 = (Exception)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            String string3 = exception.getTitle();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"exception.title");
            String string4 = exception.getSubtitle();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"exception.subtitle");
            Caption caption = new Caption(string3, string4);
            Blames blames = exception.getBlamed() ? Blames.BLAMED : Blames.NOT_BLAMED;
            List list = exception.getFramesList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"exception.framesList");
            Iterable iterable2 = list;
            Blames blames2 = blames;
            Caption caption2 = caption;
            boolean $i$f$map2 = false;
            void var14_14 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                com.google.services.firebase.insights.proto.Frame frame = (com.google.services.firebase.insights.proto.Frame)item$iv$iv2;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                collection.add(EventsKt.fromProto((com.google.services.firebase.insights.proto.Frame)it));
            }
            collection = (List)destination$iv$iv2;
            $this$map$iv2 = collection;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv2 = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Frame)element$iv$iv;
                boolean bl3 = false;
                if (!(!it.matches(trampolineFrameRegex))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Collection<Frame> collection3 = collection = (List)destination$iv$iv2;
            Blames blames3 = blames2;
            Caption caption3 = caption2;
            Stacktrace stacktrace = new Stacktrace(caption3, blames3, collection3);
            Intrinsics.checkNotNullExpressionValue((Object)exception.getType(), (String)"exception.type");
            Intrinsics.checkNotNullExpressionValue((Object)exception.getExceptionMessage(), (String)"exception.exceptionMessage");
            Stacktrace stacktrace2 = stacktrace;
            collection2.add(new ExceptionStack(stacktrace2, string2, string));
        }
        List list = (List)destination$iv$iv;
        return new StacktraceGroup(list);
    }

    @NotNull
    public static final Device fromProto(@NotNull Device.Companion $this$fromProto, @NotNull com.google.services.firebase.insights.proto.Device proto) {
        Intrinsics.checkNotNullParameter((Object)$this$fromProto, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        String string = proto.getManufacturer();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"proto.manufacturer");
        String string2 = proto.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"proto.model");
        String string3 = proto.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"proto.displayName");
        return new Device(string, string2, string3);
    }

    @NotNull
    public static final OperatingSystemInfo fromProto(@NotNull OperatingSystemInfo.Companion $this$fromProto, @NotNull OperatingSystem proto) {
        Intrinsics.checkNotNullParameter((Object)$this$fromProto, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        String string = proto.getDisplayVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"proto.displayVersion");
        String string2 = proto.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"proto.displayName");
        return new OperatingSystemInfo(string, string2);
    }

    @NotNull
    public static final com.android.tools.idea.insights.Version fromProto(@NotNull Version.Companion $this$fromProto, @NotNull Version proto) {
        Intrinsics.checkNotNullParameter((Object)$this$fromProto, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        List list = proto.getTracksList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"proto.tracksList");
        Set tracks2 = SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)fromProto.tracks.1.INSTANCE));
        String string = proto.getBuildVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"proto.buildVersion");
        String string2 = proto.getDisplayVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"proto.displayVersion");
        String string3 = proto.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"proto.displayName");
        return new com.android.tools.idea.insights.Version(string, string2, string3, tracks2);
    }

    @NotNull
    public static final com.android.tools.idea.insights.Event fromProto(@NotNull Event.Companion $this$fromProto, @NotNull Event proto) {
        Intrinsics.checkNotNullParameter((Object)$this$fromProto, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        com.google.services.firebase.insights.proto.Device device = proto.getDevice();
        Intrinsics.checkNotNullExpressionValue((Object)device, (String)"proto.device");
        Device device2 = EventsKt.fromProto(Device.Companion, device);
        OperatingSystem operatingSystem = proto.getOperatingSystem();
        Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"proto.operatingSystem");
        OperatingSystemInfo operatingSystemInfo = EventsKt.fromProto(OperatingSystemInfo.Companion, operatingSystem);
        Timestamp timestamp = proto.getEventTime();
        Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"proto.eventTime");
        EventData eventData = new EventData(device2, operatingSystemInfo, ProtobufUtilsKt.toJavaInstant(timestamp));
        List list = proto.getExceptionsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"proto.exceptionsList");
        return new com.android.tools.idea.insights.Event(eventData, EventsKt.fromProto(list));
    }

    @Nullable
    public static final com.android.tools.idea.insights.PlayTrack fromProto(@NotNull PlayTrack proto) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        TrackType trackType = proto.getType();
        return switch (trackType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[trackType.ordinal()]) {
            case 1 -> com.android.tools.idea.insights.PlayTrack.PRODUCTION;
            case 2 -> com.android.tools.idea.insights.PlayTrack.INTERNAL;
            case 3 -> com.android.tools.idea.insights.PlayTrack.OPEN_TESTING;
            case 4 -> com.android.tools.idea.insights.PlayTrack.CLOSED_TESTING;
            default -> null;
        };
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TrackType.values().length];
            try {
                nArray[TrackType.TRACK_TYPE_PROD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackType.TRACK_TYPE_INTERNAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackType.TRACK_TYPE_OPEN_TESTING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackType.TRACK_TYPE_CLOSED_TESTING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

