/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.config;

import com.android.tools.idea.insights.Connection;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.services.firebase.insights.config.GClient;
import com.google.services.firebase.insights.config.GProjectInfo;
import com.google.services.firebase.insights.config.GServices;
import com.google.services.firebase.insights.config.JsonParserKt;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "parseGoogleServices", "", "Lcom/android/tools/idea/insights/Connection;", "json", "Ljava/io/Reader;", "firebase"})
public final class JsonParserKt {
    private static final Gson gson = new Gson().newBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    @NotNull
    public static final List<Connection> parseGoogleServices(@NotNull Reader json) {
        List list;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        try {
            GServices gServices = (GServices)gson.fromJson(json, GServices.class);
            if (gServices == null) {
                return CollectionsKt.emptyList();
            }
            GServices gServices2 = gServices;
            GProjectInfo pInfo = gServices2.getProjectInfo();
            if (!pInfo.isValid()) {
                return CollectionsKt.emptyList();
            }
            list = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)gServices2.getClient()), (Function1)parseGoogleServices.1.INSTANCE), (Function1)((Function1)new Function1<GClient, Connection>(pInfo){
                final /* synthetic */ GProjectInfo $pInfo;
                {
                    this.$pInfo = $pInfo;
                    super(1);
                }

                @NotNull
                public final Connection invoke(@NotNull GClient client) {
                    Intrinsics.checkNotNullParameter((Object)client, (String)"client");
                    return new Connection(client.getClientInfo().getAndroidClientInfo().getPackageName(), client.getClientInfo().getMobilesdkAppId(), this.$pInfo.getProjectId(), this.$pInfo.getProjectNumber());
                }
            })));
        }
        catch (JsonParseException ex) {
            list = CollectionsKt.emptyList();
        }
        catch (IOException ex) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

