/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.config;

import com.android.tools.idea.projectsystem.AndroidProjectRootUtil;
import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.common.io.Files;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.config.InvalidConfigException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.InvalidDataException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class FirebaseLocalConfig {
    public static final String CONFIG_ELEMENT_PROJECT_INFO = "project_info";
    public static final String CONFIG_ELEMENT_PROJECT_NUMBER = "project_number";
    public static final String CONFIG_ELEMENT_PROJECT_ID = "project_id";
    @Nullable
    private File myConfigFile;
    @Nullable
    private String myProjectNumber;
    @Nullable
    private String myProjectId;
    @NotNull
    private Set<String> myClientsPackageNames = new HashSet<String>();
    @Nullable
    private JsonElement myJsonConfig;
    @Nullable
    private ImmutableList<InvalidConfigException> myInvalidConfigErrors;

    public FirebaseLocalConfig(@NotNull File configFile) {
        FirebaseLocalConfig.getLog().info("Config file being inspected: " + configFile);
        try {
            this.myJsonConfig = new JsonParser().parse((Reader)Files.newReader((File)configFile, (Charset)Charsets.UTF_8));
            this.myConfigFile = configFile;
            FirebaseLocalConfig.getLog().info("Config file loaded: " + this.myConfigFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (JsonIOException | JsonSyntaxException jsonException) {
            this.myInvalidConfigErrors = ImmutableList.of((Object)((Object)new InvalidLocalConfigException(new InvalidDataException("Malformed json"), "firebaseService.internalError.invalidConfigFileFormat", configFile.getAbsolutePath())));
            return;
        }
        if (!this.isLocalConfigPresent()) {
            return;
        }
        FirebaseLocalConfig.getLog().info("Loading existing Firebase config from file: " + this.myConfigFile.getAbsolutePath());
        try {
            this.loadLocalFirebaseConfig();
        }
        catch (InvalidLocalConfigException exception) {
            this.myInvalidConfigErrors = ImmutableList.of((Object)((Object)exception));
        }
    }

    @Nullable
    public static FirebaseLocalConfig fromModule(@NotNull Module module) {
        File configFile = FirebaseLocalConfig.locateLocalFirebaseConfig(module);
        if (configFile == null) {
            return null;
        }
        FirebaseLocalConfig config = new FirebaseLocalConfig(configFile);
        if (config.isLocalConfigPresent()) {
            return config;
        }
        return null;
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(FirebaseLocalConfig.class);
    }

    @Nullable
    public File getConfigFile() {
        return this.myConfigFile;
    }

    @Nullable
    public String getProjectNumber() {
        return this.myProjectNumber;
    }

    @Nullable
    public String getProjectId() {
        return this.myProjectId;
    }

    private boolean isLocalConfigPresent() {
        return this.myConfigFile != null && this.myJsonConfig != null;
    }

    @Nullable
    public List<InvalidConfigException> getConfigErrors() {
        return this.myInvalidConfigErrors;
    }

    private void loadLocalFirebaseConfig() throws InvalidLocalConfigException {
        String projectId;
        String projectNumber;
        assert (this.myConfigFile != null);
        assert (this.myJsonConfig != null);
        if (!this.myJsonConfig.isJsonObject()) {
            throw new InvalidLocalConfigException(new InvalidDataException("Malformed json, couldn't find a root json object"), "firebaseService.internalError.invalidConfigFileFormat", this.myConfigFile.getAbsolutePath());
        }
        JsonObject rootObject = this.myJsonConfig.getAsJsonObject();
        JsonObject projectInfoElement = rootObject.getAsJsonObject(CONFIG_ELEMENT_PROJECT_INFO);
        if (projectInfoElement == null) {
            throw new InvalidLocalConfigException(new InvalidDataException("project_info couldn't be found in config file."), "firebaseService.internalError.invalidConfigFileFormat", this.myConfigFile.getAbsolutePath());
        }
        JsonElement projectNumberElement = projectInfoElement.get(CONFIG_ELEMENT_PROJECT_NUMBER);
        if (projectNumberElement == null || Strings.isNullOrEmpty((String)(projectNumber = projectNumberElement.getAsString()))) {
            throw new InvalidLocalConfigException(new InvalidDataException("project_number couldn't be found in config file."), "firebaseService.internalError.invalidConfigFileFormat", this.myConfigFile.getAbsolutePath());
        }
        JsonElement projectIdElement = projectInfoElement.get(CONFIG_ELEMENT_PROJECT_ID);
        if (projectIdElement == null || Strings.isNullOrEmpty((String)(projectId = projectIdElement.getAsString()))) {
            throw new InvalidLocalConfigException(new InvalidDataException("project_id couldn't be found in config file."), "firebaseService.internalError.invalidConfigFileFormat", this.myConfigFile.getAbsolutePath());
        }
        JsonArray clientArray = rootObject.getAsJsonArray("client");
        if (clientArray != null && clientArray.size() > 0) {
            this.myClientsPackageNames = Streams.stream((Iterator)clientArray.iterator()).map(this::getPackageNameForClient).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        FirebaseLocalConfig.getLog().info("Found existing project number in local config: " + projectNumber + " - " + projectId);
        this.myProjectNumber = projectNumber;
        this.myProjectId = projectId;
    }

    private String getPackageNameForClient(JsonElement element) {
        JsonObject entry = element.getAsJsonObject();
        if (entry == null) {
            return null;
        }
        JsonObject clientInfo = entry.getAsJsonObject("client_info");
        if (clientInfo == null) {
            return null;
        }
        JsonObject androidClientInfo = clientInfo.getAsJsonObject("android_client_info");
        if (androidClientInfo == null) {
            return null;
        }
        JsonElement packageNameElement = androidClientInfo.get("package_name");
        if (packageNameElement == null) {
            return null;
        }
        return packageNameElement.getAsString();
    }

    @NotNull
    public Set<String> getMyClientsPackageNames() {
        return this.myClientsPackageNames;
    }

    private static File locateLocalFirebaseConfig(@NotNull Module module) {
        String possibleRoot = AndroidProjectRootUtil.getModuleDirPath((Module)module);
        if (possibleRoot == null) {
            return null;
        }
        File configFile = new File(possibleRoot, "google-services.json");
        if (!configFile.exists()) {
            return null;
        }
        return configFile;
    }

    public static class InvalidLocalConfigException
    extends InvalidConfigException {
        private InvalidLocalConfigException(@NotNull Throwable cause, @NotNull @PropertyKey(resourceBundle="messages.FirebaseBundle") String messageKey, Object ... messageArguments) {
            super(FirebaseBundle.message(messageKey, messageArguments), cause);
        }
    }
}

