/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.services.firebase.config.AndroidClient;
import com.google.services.firebase.config.FirebaseLocalConfig;
import com.google.services.firebase.config.GradleConfig;
import com.google.services.firebase.mobilesdk.OnlineProject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirebaseConfig {
    @Nullable
    private OnlineProject myResolvedProject;
    @Nullable
    private final FirebaseLocalConfig myFirebaseLocalConfig;
    private final Set<AndroidClient> myUnregisteredClients;
    private final Set<AndroidClient> myRegisterableClients;
    private final Map<AndroidClient, OnlineProject> myRegisteredClients;

    public FirebaseConfig(@NotNull Module androidApplicationModule) throws FirebaseLocalConfig.InvalidLocalConfigException {
        this(FirebaseLocalConfig.fromModule(androidApplicationModule), GradleConfig.fromModule(androidApplicationModule));
    }

    @VisibleForTesting
    FirebaseConfig(@Nullable FirebaseLocalConfig fileConfig, @NotNull GradleConfig gradleConfig) throws FirebaseLocalConfig.InvalidLocalConfigException {
        Pair<AndroidClient, OnlineProject> matchedClientProjectPair;
        this.myFirebaseLocalConfig = fileConfig;
        HashSet<AndroidClient> unregisteredClients = new HashSet<AndroidClient>();
        HashMap registeredClients = new HashMap();
        ImmutableList.Builder configExceptionBuilder = new ImmutableList.Builder();
        if (this.myFirebaseLocalConfig != null && this.myFirebaseLocalConfig.getConfigErrors() != null) {
            configExceptionBuilder.addAll(this.myFirebaseLocalConfig.getConfigErrors());
        }
        for (AndroidClient variant : gradleConfig.getVariants()) {
            FirebaseConfig.getLog().info("Found unregistered client: " + variant);
            if (unregisteredClients.add(variant)) continue;
            FirebaseConfig.getLog().warn("Unregistered client (" + variant.toString() + ") found on multiple Firebase projects, ignoring.");
        }
        this.myUnregisteredClients = ImmutableSet.copyOf(unregisteredClients);
        this.myRegisterableClients = this.myUnregisteredClients.stream().filter(AndroidClient::isAttemptRegistration).collect(Collectors.toSet());
        this.myRegisteredClients = ImmutableMap.copyOf(registeredClients);
        if (this.myResolvedProject == null && (matchedClientProjectPair = this.getFirstMatchedClientAndProject()) != null) {
            this.myResolvedProject = (OnlineProject)matchedClientProjectPair.getSecond();
        }
    }

    private static Logger getLog() {
        return Logger.getInstance(FirebaseConfig.class);
    }

    @Nullable
    public Pair<AndroidClient, OnlineProject> getFirstMatchedClientAndProject() {
        if (this.myRegisteredClients.isEmpty()) {
            return null;
        }
        Map.Entry<AndroidClient, OnlineProject> firstEntry = this.myRegisteredClients.entrySet().iterator().next();
        return Pair.create((Object)firstEntry.getKey(), (Object)firstEntry.getValue());
    }

    @Nullable
    public String getLocalFirebaseConfigProjectId() {
        return this.myFirebaseLocalConfig != null ? this.myFirebaseLocalConfig.getProjectId() : null;
    }

    @NotNull
    public Set<AndroidClient> getRegisterableAndroidClients() {
        return this.myRegisterableClients;
    }

    public boolean isConnected() {
        return this.myResolvedProject != null && !this.myResolvedProject.isRequiredFirebaseMigration() && this.myUnregisteredClients.isEmpty() && !this.myRegisteredClients.isEmpty() && this.myFirebaseLocalConfig != null && this.myFirebaseLocalConfig.getConfigErrors() == null && this.myResolvedProject.getProjectNumber().equals(this.myFirebaseLocalConfig.getProjectNumber());
    }
}

