/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.config;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.intellij.openapi.util.InvalidDataException;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidClient {
    @NotNull
    private final String mySha1;
    @NotNull
    private final String myPackageName;
    private final boolean myAttemptRegistration;

    AndroidClient(@NotNull String packageName, @NotNull String sha1) throws InvalidDataException {
        this(packageName, sha1, true);
    }

    AndroidClient(@NotNull String packageName, @NotNull String sha1, boolean attemptRegistration) throws InvalidDataException {
        if (Strings.isNullOrEmpty((String)packageName)) {
            throw new InvalidDataException("Invalid packageName: " + packageName);
        }
        if (Strings.isNullOrEmpty((String)sha1)) {
            throw new InvalidDataException("Invalid sha1: " + sha1);
        }
        this.myPackageName = packageName;
        this.mySha1 = AndroidClient.normalizeSha1(sha1);
        this.myAttemptRegistration = attemptRegistration;
    }

    @Nullable
    public static AndroidClient createClient(@NotNull String packageName, @NotNull String sha1, boolean attemptRegistration) {
        try {
            return new AndroidClient(packageName, sha1, attemptRegistration);
        }
        catch (InvalidDataException exception) {
            return null;
        }
    }

    @NotNull
    private static String normalizeSha1(@NotNull String sha1) {
        return sha1.replaceAll(":", "").toLowerCase(Locale.ENGLISH);
    }

    private static boolean isSha1Equal(@NotNull String left, @NotNull String right) {
        return AndroidClient.normalizeSha1(left).equals(AndroidClient.normalizeSha1(right));
    }

    @NotNull
    public String getSha1() {
        return this.mySha1;
    }

    @NotNull
    public String getPackageName() {
        return this.myPackageName;
    }

    public boolean isAttemptRegistration() {
        return this.myAttemptRegistration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidClient that = (AndroidClient)o;
        if (!AndroidClient.isSha1Equal(this.mySha1, that.mySha1)) {
            return false;
        }
        return this.myPackageName.equals(that.myPackageName);
    }

    public String toString() {
        return "AndroidClient{myPackageName='" + this.myPackageName + "', mySha1='" + this.mySha1 + "'}";
    }

    public int hashCode() {
        int result2 = this.mySha1.hashCode();
        result2 = 31 * result2 + this.myPackageName.hashCode();
        return result2;
    }
}

