/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.action.connect;

import com.android.tools.idea.assistant.AssistActionState;
import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.view.StatefulButtonMessage;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.google.common.collect.Sets;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.ModuleAsyncStateManager;
import com.google.services.firebase.action.connect.FirebaseConnectAction;
import com.google.services.firebase.config.AndroidClient;
import com.google.services.firebase.config.FirebaseLocalConfig;
import com.google.services.firebase.config.GradleConfig;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirebaseConnectStateManager
extends ModuleAsyncStateManager {
    private final Set<Project> myRegisteredProjects = new HashSet<Project>();

    private static Logger getLog() {
        return Logger.getInstance(FirebaseConnectAction.class);
    }

    public static void setCompletableState(@NotNull Module module, boolean stateOverride) {
        for (AssistActionStateManager stateManager : (AssistActionStateManager[])AssistActionStateManager.EP_NAME.getExtensions()) {
            if (!stateManager.getId().equals("firebase.connect")) continue;
            ((FirebaseConnectStateManager)stateManager).updateModuleState(module, stateOverride);
        }
    }

    @Override
    public boolean calculateState(@NotNull Module module) {
        Set<String> registeredPackageNames;
        FirebaseLocalConfig localConfig = FirebaseLocalConfig.fromModule(module);
        if (localConfig == null || localConfig.getConfigErrors() != null) {
            return true;
        }
        GradleConfig gradleConfig = GradleConfig.fromModule(module);
        Set variantsPackageNames = gradleConfig.getVariants().stream().map(AndroidClient::getPackageName).collect(Collectors.toSet());
        return !Sets.difference(variantsPackageNames, registeredPackageNames = localConfig.getMyClientsPackageNames()).isEmpty();
    }

    @Override
    public String getTaskDisplayName() {
        return FirebaseBundle.message("firebase.service.action.label.refresh.state.action", new Object[0]);
    }

    @NotNull
    public String getId() {
        return "firebase.connect";
    }

    public void init(@NotNull Project project, @NotNull ActionData actionData) {
        if (this.myRegisteredProjects.contains(project)) {
            return;
        }
        this.myRegisteredProjects.add(project);
        GradleSyncState.subscribe((Project)project, (GradleSyncListener)new GradleSyncListener(){

            public void syncSucceeded(@NotNull Project project) {
                FirebaseConnectStateManager.this.updateAllModuleStates(project);
            }

            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                FirebaseConnectStateManager.this.updateAllModuleStates(project);
            }
        });
    }

    @Nullable
    public StatefulButtonMessage getStateDisplay(@NotNull Project project, @NotNull ActionData actionData, @Nullable String successMessage) {
        String message = this.myStateMessageMap.containsKey(project) ? (String)this.myStateMessageMap.get(project) : successMessage;
        return new StatefulButtonMessage(message, (AssistActionState)this.getState(project, actionData));
    }
}

