/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.StatefulButtonNotifier;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.datamodel.DefaultActionState;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.google.services.firebase.FirebaseBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.EdtInvocationManager;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleAsyncStateManager
extends AssistActionStateManager {
    protected final Map<Project, String> myStateMessageMap = new HashMap<Project, String>();
    private final HashMap<Integer, ModuleState> myModuleStates = new HashMap();

    private static Logger getLog() {
        return Logger.getInstance(ModuleAsyncStateManager.class);
    }

    public void updateAllModuleStates(@NotNull Project project) {
        Module[] modules;
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            if (!this.myModuleStates.containsKey(module.hashCode())) continue;
            this.requestModuleStatusUpdate(module);
        }
    }

    public DefaultActionState getState(@NotNull Project project, @NotNull ActionData actionData) {
        this.myStateMessageMap.remove(project);
        List modules = GradleProjectInfo.getInstance((Project)project).getAndroidModules();
        ModuleAsyncStateManager.getLog().debug("getState called for: " + project.getName());
        int numCompleted = 0;
        for (Module module : modules) {
            if (this.myModuleStates.containsKey(module.hashCode())) {
                if (this.myModuleStates.get(module.hashCode()).isCompletable()) continue;
                ++numCompleted;
                continue;
            }
            this.requestModuleStatusUpdate(module);
            return DefaultActionState.IN_PROGRESS;
        }
        if (numCompleted == 0) {
            return DefaultActionState.INCOMPLETE;
        }
        if (numCompleted != modules.size()) {
            this.myStateMessageMap.put(project, FirebaseBundle.message("stateManager.userNote.partiallyCompleted", numCompleted, modules.size()));
            return DefaultActionState.PARTIALLY_COMPLETE;
        }
        return DefaultActionState.COMPLETE;
    }

    protected void requestModuleStatusUpdate(@NotNull Module module) {
        ModuleState currentState = this.getModuleState(module);
        currentState.startRefreshTask(module);
    }

    public void updateModuleState(Module module, boolean newIsCompletableState) {
        ModuleAsyncStateManager.getLog().debug("Updating module state: " + newIsCompletableState);
        ModuleState moduleState = this.getModuleState(module);
        if (moduleState.isCompletable() != newIsCompletableState) {
            ModuleAsyncStateManager.getLog().debug("Sending refresh notification Stateful button.");
            moduleState.setCompletable(newIsCompletableState);
            MessageBus bus = module.getProject().getMessageBus();
            StatefulButtonNotifier publisher = (StatefulButtonNotifier)bus.syncPublisher(StatefulButtonNotifier.BUTTON_STATE_TOPIC);
            publisher.stateUpdated();
        } else {
            ModuleAsyncStateManager.getLog().debug("Module state did not change.");
        }
    }

    @NotNull
    private ModuleState getModuleState(Module module) {
        ModuleState moduleState = this.myModuleStates.get(module.hashCode());
        if (moduleState == null) {
            moduleState = new ModuleState();
            this.myModuleStates.put(module.hashCode(), moduleState);
        }
        return moduleState;
    }

    public abstract boolean calculateState(@NotNull Module var1);

    public abstract String getTaskDisplayName();

    private class ModuleState {
        @NotNull
        private final Object myTaskLock = new Object();
        @Nullable
        private WeakReference<Task.Backgroundable> myModuleUpdateTask;
        private int myNumRequestedStateUpdates;
        private boolean myIsCompletable = true;

        ModuleState() {
        }

        boolean isCompletable() {
            return this.myIsCompletable;
        }

        void setCompletable(boolean completable) {
            this.myIsCompletable = completable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void startRefreshTask(Module module) {
            Object object = this.myTaskLock;
            synchronized (object) {
                ++this.myNumRequestedStateUpdates;
                if (this.myModuleUpdateTask == null || this.myModuleUpdateTask.get() == null) {
                    this.myModuleUpdateTask = new WeakReference<Task.Backgroundable>(this.runRefreshStateTask(module));
                }
            }
        }

        @NotNull
        private Task.Backgroundable runRefreshStateTask(final Module module) {
            ModuleAsyncStateManager.getLog().debug("Performing refresh task on module: " + module.getName());
            Task.Backgroundable refreshTask = new Task.Backgroundable(module.getProject(), ModuleAsyncStateManager.this.getTaskDisplayName()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    try {
                        int numStateUpdates;
                        int numLoops = 0;
                        do {
                            ++numLoops;
                            Object object = ModuleState.this.myTaskLock;
                            synchronized (object) {
                                ModuleState.this.myNumRequestedStateUpdates = 0;
                            }
                            ModuleAsyncStateManager.getLog().debug("Running calculateState");
                            try {
                                ModuleAsyncStateManager.this.updateModuleState(module, ModuleAsyncStateManager.this.calculateState(module));
                            }
                            catch (IllegalStateException e) {
                                ModuleAsyncStateManager.getLog().warn("Gradle model not available, please check your gradle scripts and resync them with Android Studio using the Build menu.", (Throwable)e);
                            }
                            object = ModuleState.this.myTaskLock;
                            synchronized (object) {
                                numStateUpdates = ModuleState.this.myNumRequestedStateUpdates;
                            }
                        } while (numStateUpdates > 0 && numLoops < 5);
                    }
                    finally {
                        Object object = ModuleState.this.myTaskLock;
                        synchronized (object) {
                            ModuleState.this.myModuleUpdateTask = null;
                        }
                    }
                }
            };
            EdtInvocationManager.getInstance().invokeLater(() -> ProgressManager.getInstance().run((Task)refreshTask));
            return refreshTask;
        }
    }
}

