/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.DefaultTutorialBundle;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.datamodel.AnalyticsProvider;
import com.android.tools.idea.assistant.datamodel.DefaultActionState;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.google.gct.login.GoogleLogin;
import com.google.services.firebase.action.connect.FirebaseConnectStateManager;
import com.google.services.firebase.mobilesdk.OnlineProject;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.FirebaseContextDetails;
import com.google.wireless.android.sdk.stats.FirebaseErrorDetails;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class FirebaseAnalyticsProvider
implements AnalyticsProvider {
    private static final ActionData myFakeActionData = new DefaultTutorialBundle.Action();

    public void trackPanelOpened(@NotNull Project project) {
        new Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_OPEN).withProject(project).log();
    }

    public void trackFeatureGroupExpanded(@NotNull String groupName, @NotNull Project project) {
        new Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_FEATURE_EXPANDED).withProject(project).withDetails(FirebaseContextDetails.newBuilder().setPerformedOn(groupName)).log();
    }

    public void trackTutorialOpen(@NotNull String tutorialId, @NotNull Project project) {
        new Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_TUTORIAL_OPENED).withProject(project).withDetails(FirebaseContextDetails.newBuilder().setPerformedOn(tutorialId)).log();
    }

    public void trackTutorialClosed(@NotNull String tutorialId, long timeOpenMs, @NotNull Project project) {
        new Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_TUTORIAL_CLOSED).withProject(project).withDetails(FirebaseContextDetails.newBuilder().setPerformedOn(tutorialId).setDuration(timeOpenMs)).log();
    }

    private static boolean isLoggedIn() {
        return GoogleLogin.getInstance().isLoggedIn();
    }

    public static class Logger {
        private AndroidStudioEvent.EventKind myKind;
        private Project myProject;
        private OnlineProject myOnlineProject;
        private FirebaseContextDetails.Builder myDetails;
        private FirebaseErrorDetails.Builder myErrorDetails;

        public Logger(@NotNull AndroidStudioEvent.EventKind kind) {
            this.myKind = kind;
        }

        public Logger withProject(@NotNull Project project) {
            this.myProject = project;
            return this;
        }

        public Logger withOnlineProject(@NotNull OnlineProject project) {
            this.myOnlineProject = project;
            return this;
        }

        public Logger withDetails(@NotNull FirebaseContextDetails.Builder details) {
            this.myDetails = details;
            return this;
        }

        public Logger withErrorDetails(@NotNull FirebaseErrorDetails.Builder errorDetails) {
            this.myErrorDetails = errorDetails;
            return this;
        }

        public void log() {
            if (this.myDetails == null) {
                this.myDetails = FirebaseContextDetails.newBuilder();
            }
            this.myDetails.setLoggedIn(FirebaseAnalyticsProvider.isLoggedIn());
            if (this.myOnlineProject != null) {
                this.myDetails.setProjectId(this.myOnlineProject.getProjectId()).setProjectNumber(this.myOnlineProject.getProjectNumber());
            }
            FirebaseConnectStateManager stateManager = null;
            for (AssistActionStateManager manager : (AssistActionStateManager[])AssistActionStateManager.EP_NAME.getExtensions()) {
                if (!(manager instanceof FirebaseConnectStateManager)) continue;
                stateManager = (FirebaseConnectStateManager)manager;
                break;
            }
            if (stateManager != null && this.myProject != null) {
                DefaultActionState state = stateManager.getState(this.myProject, myFakeActionData);
                this.myDetails.setConnectStatus(switch (state) {
                    case DefaultActionState.COMPLETE -> FirebaseContextDetails.ConnectStatus.CONNECTED;
                    case DefaultActionState.INCOMPLETE -> FirebaseContextDetails.ConnectStatus.NOT_CONNECTED;
                    case DefaultActionState.PARTIALLY_COMPLETE -> FirebaseContextDetails.ConnectStatus.PARTIALLY_CONNECTED;
                    default -> FirebaseContextDetails.ConnectStatus.UNKNOWN_CONNECT_STATUS;
                });
            }
            AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.FIREBASE_ASSISTANT).setKind(this.myKind).setFirebaseContextDetails(this.myDetails);
            if (this.myErrorDetails != null) {
                event.setFirebaseErrorDetails(this.myErrorDetails);
            }
            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId((AndroidStudioEvent.Builder)event, (Project)this.myProject));
        }
    }
}

