/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.samples;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.SettableValue;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.expressions.value.TransformOptionalExpression;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.WizardModel;
import com.android.tools.idea.wizard.ui.deprecated.StudioWizardStepPanel;
import com.android.utils.HtmlBuilder;
import com.appspot.gsamplesindex.samplesindex.model.Sample;
import com.appspot.gsamplesindex.samplesindex.model.SampleCollection;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gct.studio.samples.SampleImportTreeManager;
import com.google.gct.studio.samples.SampleModel;
import com.google.gct.studio.samples.SamplePreviewPanel;
import com.google.gct.studio.samples.SampleSetupStep;
import com.google.gct.studio.util.GctStudioBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class SampleBrowserStep
extends ModelWizardStep<SampleModel> {
    private final SampleCollection mySampleList;
    private final SampleSetupStep mySampleSetupStep;
    private final StudioWizardStepPanel myStudioPanel;
    private final ValidatorPanel myValidatorPanel;
    private final ListenerManager myListeners;
    private final BindingsManager myBindings;
    private Tree mySampleTree;
    private SampleImportTreeManager mySampleTreeManager;
    private JPanel myPanel;
    private JEditorPane myDescriptionPane;
    private SearchTextField mySearchBox;
    private SamplePreviewPanel mySamplePreviewPanel;
    private JBScrollPane mySamplePreviewScrollPanel;
    private JPanel myDescriptionPanel;
    private JSplitPane mySplitPane;

    public SampleBrowserStep(@NotNull SampleModel model, @NotNull SampleCollection sampleList) {
        super((WizardModel)model, GctStudioBundle.message("sample.browser.title", new Object[0]));
        this.$$$setupUI$$$();
        this.myListeners = new ListenerManager();
        this.myBindings = new BindingsManager();
        this.mySampleList = sampleList;
        this.mySampleTreeManager = new SampleImportTreeManager(this.mySampleTree, this.mySampleList);
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel);
        this.myStudioPanel = new StudioWizardStepPanel((JPanel)this.myValidatorPanel, GctStudioBundle.message("sample.browser.description", new Object[0]));
        this.mySampleSetupStep = new SampleSetupStep(model);
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.mySplitPane);
        this.myDescriptionPane = SwingHelper.createHtmlViewer((boolean)false, null, null, null);
        this.myDescriptionPane.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        this.myDescriptionPanel.add(this.myDescriptionPane);
        this.mySamplePreviewScrollPanel.getVerticalScrollBar().setUnitIncrement(16);
    }

    @NotNull
    protected JComponent getComponent() {
        return this.myStudioPanel;
    }

    public JComponent getPreferredFocusComponent() {
        return this.mySearchBox;
    }

    @NotNull
    protected Collection<? extends ModelWizardStep<?>> createDependentSteps() {
        return Lists.newArrayList((Object[])new SampleSetupStep[]{this.mySampleSetupStep});
    }

    protected void onWizardStarting(final @NotNull ModelWizard.Facade wizard) {
        final OptionalProperty<Sample> sample = ((SampleModel)this.getModel()).sample();
        sample.setNullableValue((Object)this.mySampleTreeManager.getSelectedSample());
        this.mySampleTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                sample.setNullableValue((Object)SampleBrowserStep.this.mySampleTreeManager.getSelectedSample());
            }
        });
        DoubleClickListener treeDoubleClicked = new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                return wizard.goForward();
            }
        };
        treeDoubleClicked.installOn((Component)this.mySampleTree);
        this.myListeners.listenAndFire(sample, () -> {
            Sample sampleValue = (Sample)sample.getValueOrNull();
            this.mySamplePreviewPanel.setSample(sampleValue);
            this.mySampleSetupStep.setUrl(sampleValue != null ? sampleValue.getCloneUrl() : "");
        });
        StringValueProperty htmlDesc = new StringValueProperty();
        this.myBindings.bind((SettableValue)htmlDesc, (ObservableValue)new TransformOptionalExpression<Sample, String>("", sample){

            @NotNull
            protected String transform(@NotNull Sample sample) {
                HtmlBuilder description = new HtmlBuilder();
                if (sample.getDescription() != null) {
                    description.addHtml(sample.getDescription());
                } else {
                    description.add(GctStudioBundle.message("sample.browser.no.description", new Object[0]));
                }
                description.newlineIfNecessary().newline();
                description.add("Tags: ");
                description.add(StringUtil.join((Collection)sample.getCategories(), (String)","));
                description.newlineIfNecessary().newline();
                StringBuilder urlBuilder = new StringBuilder();
                String cloneUrl = sample.getCloneUrl();
                String path = sample.getPath();
                urlBuilder.append(cloneUrl);
                if (!Strings.isNullOrEmpty((String)path)) {
                    urlBuilder.append(cloneUrl.endsWith("/") ? "" : "/");
                    urlBuilder.append("tree/master/");
                    urlBuilder.append(SampleModel.trimSlashes(path));
                }
                description.addLink(GctStudioBundle.message("sample.browse.source", new Object[0]), urlBuilder.toString());
                return description.getHtml();
            }
        });
        this.myListeners.listenAndFire((ObservableValue)htmlDesc, () -> this.lambda$onWizardStarting$1((StringProperty)htmlDesc));
        TextProperty searchValue = new TextProperty((JTextComponent)this.mySearchBox.getTextEditor());
        this.myListeners.listenAndFire((ObservableValue)searchValue, keyword -> this.mySampleTreeManager.filterTree((String)keyword));
        this.myValidatorPanel.registerValidator(sample, (Validator)new Validator<Optional<Sample>>(){

            @NotNull
            public Validator.Result validate(@NotNull Optional<Sample> sample) {
                if (SampleBrowserStep.this.mySampleTreeManager.isEmpty()) {
                    return new Validator.Result(Validator.Severity.ERROR, GctStudioBundle.message("sample.browser.empty", new Object[0]));
                }
                if (!sample.isPresent()) {
                    return new Validator.Result(Validator.Severity.ERROR, GctStudioBundle.message("sample.browser.please.select", new Object[0]));
                }
                return Validator.Result.OK;
            }
        }, new ObservableValue[0]);
    }

    @NotNull
    protected ObservableBool canGoForward() {
        return this.myValidatorPanel.hasErrors().not();
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    private /* synthetic */ void lambda$onWizardStarting$1(StringProperty htmlDesc) {
        SwingHelper.setHtml((JEditorPane)this.myDescriptionPane, (String)((String)htmlDesc.get()), (Color)UIUtil.getLabelForeground());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SamplePreviewPanel samplePreviewPanel;
        JPanel jPanel;
        JBScrollPane jBScrollPane;
        Tree tree;
        SearchTextField searchTextField;
        JSplitPane jSplitPane;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySplitPane = jSplitPane = new JSplitPane();
        jSplitPane.setDividerSize(8);
        jSplitPane.setResizeWeight(0.5);
        jPanel2.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setLeftComponent(jPanel3);
        this.mySearchBox = searchTextField = new SearchTextField();
        searchTextField.setToolTipText("Search by Name or Key Word");
        jPanel3.add((Component)searchTextField, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jBScrollPane2.setEnabled(true);
        jPanel3.add((Component)jBScrollPane2, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.mySampleTree = tree = new Tree();
        jBScrollPane2.setViewportView((Component)tree);
        this.mySamplePreviewScrollPanel = jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jBScrollPane.setVerticalScrollBarPolicy(20);
        jSplitPane.setRightComponent((Component)jBScrollPane);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        jBScrollPane.setViewportView(jPanel4);
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), null, 0, 0, null, null));
        this.myDescriptionPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        jPanel4.add((Component)jPanel, gridBagConstraints);
        this.mySamplePreviewPanel = samplePreviewPanel = new SamplePreviewPanel();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(10, 0, 0, 0);
        jPanel4.add((Component)samplePreviewPanel, gridBagConstraints2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

