/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.deploy;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.services.appengine.v1.model.Location;
import com.google.gct.idea.appengine.admin.AppEngineAdminService;
import com.google.gct.idea.appengine.admin.AppEngineLocationSelectorItem;
import com.google.gct.idea.appengine.admin.GoogleApiException;
import com.google.gct.idea.ui.BrowserOpeningHyperLinkListener;
import com.google.gct.studio.util.GctStudioBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineApplicationCreateDialog
extends DialogWrapper {
    private static final String LOCATIONS_DOCUMENTATION_URL = "https://cloud.google.com/docs/geography-and-regions";
    private static final String FLEX_DOCUMENTATION_URL = "https://cloud.google.com/appengine/docs/flexible";
    private static final String STANDARD_DOCUMENTATION_URL = "https://cloud.google.com/appengine/docs/about-the-standard-environment";
    private static final String HTML_OPEN_TAG = "<html><font face='sans' size='-1'>";
    private static final String HTML_CLOSE_TAG = "</font></html>";
    private JPanel panel;
    private JTextPane instructionsTextPane;
    private JComboBox<AppEngineLocationSelectorItem> regionComboBox;
    private JTextPane statusPane;
    private JTextPane regionDetailPane;
    private final Credential userCredential;
    private final String gcpProjectId;

    public AppEngineApplicationCreateDialog(@NotNull Component parent, @NotNull String gcpProjectId, @NotNull Credential userCredential) {
        super(parent, false);
        this.gcpProjectId = gcpProjectId;
        this.userCredential = userCredential;
        this.$$$setupUI$$$();
        this.init();
    }

    protected void init() {
        super.init();
        this.setTitle(GctStudioBundle.message("appengine.application.region.select", new Object[0]));
        this.refreshLocationsSelector();
        this.regionComboBox.addItemListener(event -> {
            if (event.getStateChange() == 1) {
                this.updateLocationDetailMessage();
            }
        });
        this.regionDetailPane.addHyperlinkListener((HyperlinkListener)new BrowserOpeningHyperLinkListener());
        this.instructionsTextPane.addHyperlinkListener((HyperlinkListener)new BrowserOpeningHyperLinkListener());
        this.instructionsTextPane.setText(HTML_OPEN_TAG + GctStudioBundle.message("appengine.application.create.instructions", new Object[0]) + "<p>" + GctStudioBundle.message("appengine.application.create.documentation", "<a href=\"https://cloud.google.com/docs/geography-and-regions\">", "</a>") + "</p></font></html>");
    }

    protected void doOKAction() {
        Location selectedLocation = ((AppEngineLocationSelectorItem)this.regionComboBox.getSelectedItem()).getLocation();
        this.disable();
        try {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> AppEngineAdminService.getInstance().createApplication(selectedLocation.getLocationId(), this.gcpProjectId, this.userCredential), GctStudioBundle.message("appengine.application.create.loading", selectedLocation.getLocationId()), true, ProjectManager.getInstance().getDefaultProject());
            this.close(0);
        }
        catch (IOException e) {
            this.setStatusMessage(GctStudioBundle.message("appengine.application.create.error.transient", new Object[0]), true);
        }
        catch (GoogleApiException e) {
            this.setStatusMessage(e.getMessage(), true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.enable();
        }
    }

    private void setStatusMessageAsync(String message, boolean isError) {
        ApplicationManager.getApplication().invokeLater(() -> this.setStatusMessage(message, isError), ModalityState.stateForComponent((Component)this.getContentPane()));
    }

    private void setStatusMessage(String message, boolean isError) {
        this.statusPane.setText(message);
        this.statusPane.setForeground((Color)(isError ? JBColor.red : JBColor.black));
        this.statusPane.setVisible(true);
    }

    private void refreshLocationsSelector() {
        this.disable();
        this.regionComboBox.removeAllItems();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            List appEngineRegions;
            try {
                appEngineRegions = AppEngineAdminService.getInstance().getAllAppEngineLocations(this.userCredential);
            }
            catch (GoogleApiException | IOException e) {
                this.setStatusMessageAsync(GctStudioBundle.message("appengine.application.region.list.fetch.error", new Object[0]), true);
                this.enable();
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                for (Location location : appEngineRegions) {
                    this.regionComboBox.addItem(new AppEngineLocationSelectorItem(location));
                }
                this.enable();
            }, ModalityState.stateForComponent((Component)this.getContentPane()));
        });
    }

    private void disable() {
        this.regionComboBox.setEnabled(false);
        this.setOKActionEnabled(false);
    }

    private void enable() {
        this.regionComboBox.setEnabled(true);
        this.setOKActionEnabled(true);
    }

    private void updateLocationDetailMessage() {
        AppEngineLocationSelectorItem item = (AppEngineLocationSelectorItem)this.regionComboBox.getSelectedItem();
        String displayText = HTML_OPEN_TAG + GctStudioBundle.message("appengine.application.region.supported.environments", "<strong>" + item.getLocation().getLocationId() + "</strong>") + "<ul>";
        if (item.isStandardSupported()) {
            displayText = displayText + "<li>" + GctStudioBundle.message("appengine.application.region.supports.standard", "<a href=\"https://cloud.google.com/appengine/docs/about-the-standard-environment\">", "</a>") + "</li>";
        }
        if (item.isFlexSupported()) {
            displayText = displayText + "<li>" + GctStudioBundle.message("appengine.application.region.supports.flex", "<a href=\"https://cloud.google.com/appengine/docs/flexible\">", "</a>") + "</li>";
        }
        displayText = displayText + "</ul></font></html>";
        this.regionDetailPane.setText(displayText);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.panel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextPane jTextPane;
        JTextPane jTextPane2;
        JTextPane jTextPane3;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setPreferredSize(new Dimension(500, 150));
        jPanel.setRequestFocusEnabled(true);
        this.instructionsTextPane = jTextPane3 = new JTextPane();
        jTextPane3.setContentType("text/html");
        jTextPane3.setEditable(false);
        ((Component)jTextPane3).setEnabled(true);
        jTextPane3.setFocusable(false);
        jTextPane3.setMargin(new Insets(3, 3, 10, 3));
        jTextPane3.setOpaque(false);
        jTextPane3.setText("<html>\n  <head>\n    \n  </head>\n  <body>\n  </body>\n</html>\n");
        jPanel.add((Component)jTextPane3, new GridConstraints(0, 0, 1, 1, 0, 3, 1, 6, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.regionComboBox = jComboBox;
        ((Component)jComboBox).setEnabled(true);
        Font font = this.$$$getFont$$$(null, -1, -1, jComboBox.getFont());
        if (font != null) {
            jComboBox.setFont(font);
        }
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel.add(jComboBox, new GridConstraints(2, 0, 1, 1, 0, 1, 1, 0, new Dimension(200, -1), null, null));
        this.statusPane = jTextPane2 = new JTextPane();
        jTextPane2.setEditable(false);
        jTextPane2.setFocusable(false);
        jTextPane2.setOpaque(false);
        jTextPane2.setText("");
        ((Component)jTextPane2).setVisible(false);
        jPanel.add((Component)jTextPane2, new GridConstraints(1, 0, 1, 1, 0, 3, 1, 6, null, null, null));
        this.regionDetailPane = jTextPane = new JTextPane();
        jTextPane.setContentType("text/html");
        jTextPane.setEditable(false);
        jTextPane.setFocusable(false);
        jTextPane.setMargin(new Insets(10, 3, 3, 3));
        jTextPane.setOpaque(false);
        jPanel.add((Component)jTextPane, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 6, new Dimension(300, -1), null, null, 2));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }
}

