/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.util;

import android.databinding.tool.util.SymbolTable;
import com.google.common.collect.ImmutableList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001b\u0010\t\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J \u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eJ\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u000eH\u00d6\u0001R\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Landroid/databinding/tool/util/Resources;", "", "symbolTables", "Lcom/google/common/collect/ImmutableList;", "Landroid/databinding/tool/util/SymbolTable;", "(Lcom/google/common/collect/ImmutableList;)V", "getSymbolTables", "()Lcom/google/common/collect/ImmutableList;", "component1", "copy", "equals", "", "other", "getRPackagePrefix", "", "packageName", "type", "name", "hashCode", "", "toString", "db-compiler"})
public final class Resources {
    @Nullable
    private final ImmutableList<SymbolTable> symbolTables;

    public Resources(@Nullable ImmutableList<SymbolTable> symbolTables) {
        this.symbolTables = symbolTables;
    }

    @Nullable
    public final ImmutableList<SymbolTable> getSymbolTables() {
        return this.symbolTables;
    }

    @NotNull
    public final String getRPackagePrefix(@Nullable String packageName, @NotNull String type, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (Intrinsics.areEqual((Object)"android", (Object)packageName)) {
            return "android.";
        }
        if (this.symbolTables != null) {
            for (SymbolTable table : this.symbolTables) {
                if (!table.contains(type, name)) continue;
                if (((CharSequence)table.getRPackage()).length() == 0) {
                    return "";
                }
                return table.getRPackage() + '.';
            }
            throw new RuntimeException("Resource not found: " + type + ' ' + name + '.');
        }
        return "";
    }

    @Nullable
    public final ImmutableList<SymbolTable> component1() {
        return this.symbolTables;
    }

    @NotNull
    public final Resources copy(@Nullable ImmutableList<SymbolTable> symbolTables) {
        return new Resources(symbolTables);
    }

    public static /* synthetic */ Resources copy$default(Resources resources, ImmutableList immutableList, int n, Object object) {
        if ((n & 1) != 0) {
            immutableList = resources.symbolTables;
        }
        return resources.copy(immutableList);
    }

    @NotNull
    public String toString() {
        return "Resources(symbolTables=" + this.symbolTables + ')';
    }

    public int hashCode() {
        return this.symbolTables == null ? 0 : this.symbolTables.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Resources)) {
            return false;
        }
        Resources resources = (Resources)other;
        return Intrinsics.areEqual(this.symbolTables, resources.symbolTables);
    }
}

