/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.reflection;

import android.databinding.tool.reflection.ImmutableImportBag;
import android.databinding.tool.reflection.ImportBag;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.util.L;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018BA\u0012:\u0010\u0002\u001a6\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0015\u0012\u0013\u0018\u00010\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0003\u00a2\u0006\u0002\u0010\u000bJ\u001a\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\bJ\u0006\u0010\u0016\u001a\u00020\u0017R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\n0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0002\u001a6\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0015\u0012\u0013\u0018\u00010\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroid/databinding/tool/reflection/ClassFinderCache;", "", "doFind", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "className", "Landroid/databinding/tool/reflection/ImportBag;", "imports", "Landroid/databinding/tool/reflection/ModelClass;", "(Lkotlin/jvm/functions/Function2;)V", "cache", "", "Landroid/databinding/tool/reflection/ClassFinderCache$CacheKey;", "hit", "", "importCache", "Landroid/databinding/tool/reflection/ImmutableImportBag;", "miss", "missForNull", "find", "logStats", "", "CacheKey", "db-compiler"})
@SourceDebugExtension(value={"SMAP\nClassFinderCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassFinderCache.kt\nandroid/databinding/tool/reflection/ClassFinderCache\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,69:1\n359#2,7:70\n*S KotlinDebug\n*F\n+ 1 ClassFinderCache.kt\nandroid/databinding/tool/reflection/ClassFinderCache\n*L\n36#1:70,7\n*E\n"})
public final class ClassFinderCache {
    @NotNull
    private final Function2<String, ImportBag, ModelClass> doFind;
    @NotNull
    private final Map<CacheKey, ModelClass> cache;
    @NotNull
    private final Map<ImportBag, ImmutableImportBag> importCache;
    private int hit;
    private int miss;
    private int missForNull;

    public ClassFinderCache(@NotNull Function2<? super String, ? super ImportBag, ? extends ModelClass> doFind) {
        Intrinsics.checkNotNullParameter(doFind, (String)"doFind");
        this.doFind = doFind;
        this.cache = new LinkedHashMap();
        this.importCache = new LinkedHashMap();
    }

    @Nullable
    public final ModelClass find(@NotNull String className, @Nullable ImportBag imports) {
        ImmutableImportBag immutableImportBag;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        if (imports == null) {
            immutableImportBag = null;
        } else {
            ImmutableImportBag immutableImportBag2;
            Map<ImportBag, ImmutableImportBag> $this$getOrPut$iv = this.importCache;
            boolean $i$f$getOrPut = false;
            ImmutableImportBag value$iv = $this$getOrPut$iv.get(imports);
            if (value$iv == null) {
                boolean bl = false;
                ImmutableImportBag answer$iv = imports.toImmutable();
                $this$getOrPut$iv.put(imports, answer$iv);
                immutableImportBag2 = answer$iv;
            } else {
                immutableImportBag2 = value$iv;
            }
            immutableImportBag = immutableImportBag2;
        }
        ImmutableImportBag immutableImports = immutableImportBag;
        CacheKey key = new CacheKey(className, immutableImports);
        ModelClass existing = this.cache.get(key);
        if (existing == null) {
            int value$iv = this.miss;
            this.miss = value$iv + 1;
            ModelClass found = (ModelClass)this.doFind.invoke((Object)className, (Object)imports);
            if (found != null) {
                this.cache.put(key, found);
                return found;
            }
            int n = this.missForNull;
            this.missForNull = n + 1;
            return found;
        }
        int n = this.hit;
        this.hit = n + 1;
        return existing;
    }

    public final void logStats() {
        float ratio = (float)this.miss * 1.0f / (float)(this.miss + this.hit);
        int nonNullMiss = this.miss - this.missForNull;
        float nonNullRatio = (float)nonNullMiss * 1.0f / (float)(nonNullMiss + this.hit);
        L.w("class finder cache: miss: " + this.miss + ", hit: " + this.hit + ", ratio : " + ratio + ", ratio w/o nulls: " + nonNullRatio, new Object[0]);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Landroid/databinding/tool/reflection/ClassFinderCache$CacheKey;", "", "className", "", "imports", "Landroid/databinding/tool/reflection/ImmutableImportBag;", "(Ljava/lang/String;Landroid/databinding/tool/reflection/ImmutableImportBag;)V", "getClassName", "()Ljava/lang/String;", "getImports", "()Landroid/databinding/tool/reflection/ImmutableImportBag;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "db-compiler"})
    private static final class CacheKey {
        @NotNull
        private final String className;
        @Nullable
        private final ImmutableImportBag imports;

        public CacheKey(@NotNull String className, @Nullable ImmutableImportBag imports) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            this.className = className;
            this.imports = imports;
        }

        @NotNull
        public final String getClassName() {
            return this.className;
        }

        @Nullable
        public final ImmutableImportBag getImports() {
            return this.imports;
        }

        @NotNull
        public final String component1() {
            return this.className;
        }

        @Nullable
        public final ImmutableImportBag component2() {
            return this.imports;
        }

        @NotNull
        public final CacheKey copy(@NotNull String className, @Nullable ImmutableImportBag imports) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            return new CacheKey(className, imports);
        }

        public static /* synthetic */ CacheKey copy$default(CacheKey cacheKey, String string, ImmutableImportBag immutableImportBag, int n, Object object) {
            if ((n & 1) != 0) {
                string = cacheKey.className;
            }
            if ((n & 2) != 0) {
                immutableImportBag = cacheKey.imports;
            }
            return cacheKey.copy(string, immutableImportBag);
        }

        @NotNull
        public String toString() {
            return "CacheKey(className=" + this.className + ", imports=" + this.imports + ')';
        }

        public int hashCode() {
            int result = this.className.hashCode();
            result = result * 31 + (this.imports == null ? 0 : this.imports.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)other;
            if (!Intrinsics.areEqual((Object)this.className, (Object)cacheKey.className)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.imports, (Object)cacheKey.imports);
        }
    }
}

