/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.uiDesigner;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uiDesigner.binding.FormClassIndex;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.uiDesigner.ConvertFormToDslActionKt;
import org.jetbrains.idea.devkit.uiDesigner.DevKitUIDesignerBundle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/devkit/uiDesigner/ConvertFormToDslAction;", "", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.devkit.uiDesigner"})
public final class ConvertFormToDslAction {
    public final void actionPerformed(@NotNull AnActionEvent e) {
        Editor editor = (Editor)e.getRequiredData(CommonDataKeys.EDITOR);
        Object object = e.getRequiredData(CommonDataKeys.PSI_FILE);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.psi.PsiJavaFile");
        PsiJavaFile psiFile = (PsiJavaFile)object;
        Project project = psiFile.getProject();
        PsiElement element = psiFile.findElementAt(editor.getCaretModel().getOffset());
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (psiClass == null) {
            ConvertFormToDslAction $this$actionPerformed_u24lambda_u240 = this;
            boolean bl = false;
            HintManager.getInstance().showErrorHint(editor, DevKitUIDesignerBundle.message("convert.form.hint.caret.not.in.form.bound.class", new Object[0]));
            return;
        }
        PsiClass psiClass2 = psiClass;
        String string = psiClass2.getQualifiedName();
        if (string == null) {
            return;
        }
        String qName = string;
        PsiFile psiFile2 = (PsiFile)CollectionsKt.singleOrNull((List)FormClassIndex.findFormsBoundToClass((Project)project, (String)qName));
        if (psiFile2 == null) {
            ConvertFormToDslAction $this$actionPerformed_u24lambda_u241 = this;
            boolean bl = false;
            Object[] objectArray = new Object[]{qName};
            HintManager.getInstance().showErrorHint(editor, DevKitUIDesignerBundle.message("convert.form.hint.class.not.bound.to.form", objectArray));
            return;
        }
        PsiFile formFile = psiFile2;
        ConvertFormToDslActionKt.convertFormToUiDsl(psiClass2, formFile);
    }

    public final void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(e.getData(CommonDataKeys.PSI_FILE) instanceof PsiJavaFile && e.getData(CommonDataKeys.EDITOR) != null);
    }
}

