/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.themes.actions;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.TempUIThemeBasedLookAndFeelInfo;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ui.StartupUiUtil;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

final class RollbackThemeAction
extends DumbAwareAction {
    RollbackThemeAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        UIManager.LookAndFeelInfo feel;
        EditorColorsManagerImpl colorsManager = (EditorColorsManagerImpl)EditorColorsManager.getInstance();
        EditorColorsScheme scheme = colorsManager.getGlobalScheme();
        if (EditorColorsManagerImpl.isTempScheme((EditorColorsScheme)scheme)) {
            colorsManager.getSchemeManager().removeScheme((Object)scheme);
            colorsManager.loadState(colorsManager.getState());
        }
        if ((feel = LafManager.getInstance().getCurrentLookAndFeel()) instanceof TempUIThemeBasedLookAndFeelInfo) {
            LafManager.getInstance().setCurrentLookAndFeel(((TempUIThemeBasedLookAndFeelInfo)feel).getPreviousLaf());
        } else {
            LafManager.getInstance().setCurrentLookAndFeel(feel);
        }
        EditorColorsManagerImpl manager = (EditorColorsManagerImpl)EditorColorsManager.getInstance();
        manager.schemeChangedOrSwitched(manager.getGlobalScheme());
        AppUIUtil.updateForDarcula((boolean)StartupUiUtil.isUnderDarcula());
        LafManager.getInstance().updateUI();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        UIManager.LookAndFeelInfo feel = LafManager.getInstance().getCurrentLookAndFeel();
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        e.getPresentation().setEnabled(feel instanceof TempUIThemeBasedLookAndFeelInfo || EditorColorsManagerImpl.isTempScheme((EditorColorsScheme)scheme));
    }
}

