/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.themes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.uast.UastHintedVisitorAdapter;
import com.intellij.ui.JBColor;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.themes.DevKitThemesBundle;
import org.jetbrains.idea.devkit.themes.metadata.UIThemeMetadataService;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public class UnregisteredNamedColorInspection
extends DevKitUastInspectionBase {
    private static final String JB_COLOR_FQN = JBColor.class.getCanonicalName();
    private static final String NAMED_COLOR_METHOD_NAME = "namedColor";
    private static final Class<? extends UElement>[] U_ELEMENT_TYPES_HINT = new Class[]{UCallExpression.class};

    @Override
    protected PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(){

            public boolean visitExpression(@NotNull UExpression node) {
                UElement parent;
                if (node instanceof UCallExpression) {
                    UnregisteredNamedColorInspection.handleCallExpression(holder, (UCallExpression)node);
                } else if (node instanceof UQualifiedReferenceExpression && (parent = node.getUastParent()) instanceof UCallExpression) {
                    UnregisteredNamedColorInspection.handleCallExpression(holder, (UCallExpression)parent);
                }
                return true;
            }
        }, (Class[])U_ELEMENT_TYPES_HINT);
    }

    private static void handleCallExpression(@NotNull ProblemsHolder holder, @NotNull UCallExpression expression) {
        if (!UnregisteredNamedColorInspection.isNamedColorCall(expression)) {
            return;
        }
        String key = UnregisteredNamedColorInspection.getKey(expression);
        if (key == null) {
            return;
        }
        if (!UnregisteredNamedColorInspection.isRegisteredNamedColor(key)) {
            UnregisteredNamedColorInspection.registerProblem(key, holder, expression);
        }
    }

    private static boolean isNamedColorCall(@NotNull UCallExpression expression) {
        if (expression.getKind() != UastCallKind.METHOD_CALL) {
            return false;
        }
        if (!NAMED_COLOR_METHOD_NAME.equals(expression.getMethodName())) {
            return false;
        }
        PsiMethod resolved = expression.resolve();
        if (resolved == null) {
            return false;
        }
        PsiClass containingClass = resolved.getContainingClass();
        return containingClass != null && JB_COLOR_FQN.equals(containingClass.getQualifiedName());
    }

    @Nullable
    private static String getKey(@NotNull UCallExpression expression) {
        List arguments = expression.getValueArguments();
        if (arguments.isEmpty()) {
            return null;
        }
        UExpression firstArgument = (UExpression)arguments.get(0);
        Object evaluated = firstArgument.evaluate();
        if (!(evaluated instanceof String)) {
            return null;
        }
        return (String)evaluated;
    }

    private static boolean isRegisteredNamedColor(@NotNull String key) {
        return UIThemeMetadataService.getInstance().findByKey(key) != null;
    }

    private static void registerProblem(@NotNull String key, @NotNull ProblemsHolder holder, @NotNull UCallExpression expression) {
        UIdentifier identifier = expression.getMethodIdentifier();
        if (identifier == null) {
            return;
        }
        PsiElement identifierPsi = identifier.getPsi();
        if (identifierPsi == null) {
            return;
        }
        holder.registerProblem(identifierPsi, DevKitThemesBundle.message("inspections.unregistered.named.color", key), new LocalQuickFix[]{new LocalQuickFix(){

            @Nls(capitalization=Nls.Capitalization.Sentence)
            @NotNull
            public String getFamilyName() {
                return DevKitThemesBundle.message("inspections.unregistered.named.color.fix.navigate.theme.metadata.file", new Object[0]);
            }

            public boolean startInWriteAction() {
                return false;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                Collection metadataFiles = FilenameIndex.getAllFilesByExt((Project)project, (String)"themeMetadata.json");
                if (metadataFiles.isEmpty()) {
                    return;
                }
                PsiFile[] psiFiles = PsiUtilCore.toPsiFiles((PsiManager)PsiManager.getInstance((Project)project), (Collection)metadataFiles).toArray(PsiFile.EMPTY_ARRAY);
                DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> NavigationUtil.getPsiElementPopup((PsiElement[])psiFiles, (String)DevKitThemesBundle.message("inspections.unregistered.named.color.fix.navigate.theme.metadata.file.popup.title", new Object[0])).showInBestPositionFor(context));
            }

            @NotNull
            public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
                return IntentionPreviewInfo.EMPTY;
            }
        }});
    }
}

