/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.themes;

import com.google.common.collect.Lists;
import com.intellij.ide.ui.UIThemeMetadata;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.themes.metadata.UIThemeMetadataService;

public final class ThemeJsonUtil {
    @NonNls
    private static final String UI_PROPERTY_NAME = "ui";
    @NonNls
    private static final String COLORS_PROPERTY_NAME = "colors";

    static boolean isInsideUiProperty(@NotNull JsonProperty property) {
        JsonProperty parent = property;
        while ((parent = parent.getParent()) != null) {
            if (!(parent instanceof JsonProperty) || !UI_PROPERTY_NAME.equals(parent.getName())) continue;
            return true;
        }
        return false;
    }

    static String getParentNames(@NotNull JsonProperty property) {
        List parentProperties = PsiTreeUtil.collectParents((PsiElement)property, JsonProperty.class, (boolean)false, e -> e instanceof JsonProperty && UI_PROPERTY_NAME.equals(((JsonProperty)e).getName()));
        return Lists.reverse((List)parentProperties).stream().map(p -> p.getName()).collect(Collectors.joining("."));
    }

    public static boolean isThemeFilename(@NotNull String fileName) {
        return StringUtil.endsWithIgnoreCase((String)fileName, (String)".theme.json");
    }

    static List<JsonProperty> getNamedColors(@NotNull JsonFile themeFile) {
        JsonValue topLevelValue = themeFile.getTopLevelValue();
        if (!(topLevelValue instanceof JsonObject)) {
            return Collections.emptyList();
        }
        JsonProperty colorsProperty = ((JsonObject)topLevelValue).findProperty(COLORS_PROPERTY_NAME);
        if (colorsProperty == null) {
            return Collections.emptyList();
        }
        JsonValue colorsValue = colorsProperty.getValue();
        if (!(colorsValue instanceof JsonObject)) {
            return Collections.emptyList();
        }
        return ((JsonObject)colorsValue).getPropertyList();
    }

    @Nullable
    static Pair<UIThemeMetadata, UIThemeMetadata.UIKeyMetadata> findMetadata(@NotNull JsonProperty property) {
        String key = property.getName();
        Pair<UIThemeMetadata, UIThemeMetadata.UIKeyMetadata> byName = UIThemeMetadataService.getInstance().findByKey(key);
        if (byName != null) {
            return byName;
        }
        return UIThemeMetadataService.getInstance().findByKey(ThemeJsonUtil.getParentNames(property) + "." + key);
    }
}

