/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.themes;

import com.intellij.codeInsight.javadoc.JavaDocInfoGeneratorFactory;
import com.intellij.ide.ui.UIThemeMetadata;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.lang.documentation.DocumentationMarkup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.themes.DevKitThemesBundle;
import org.jetbrains.idea.devkit.themes.ThemeJsonUtil;

public class ThemeJsonDocumentationProvider
extends AbstractDocumentationProvider {
    @Nullable
    @Nls
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        Pair<UIThemeMetadata, UIThemeMetadata.UIKeyMetadata> resolve = ThemeJsonDocumentationProvider.resolve(element);
        if (resolve == null) {
            return null;
        }
        return new HtmlBuilder().append((HtmlChunk)HtmlChunk.text((String)((UIThemeMetadata.UIKeyMetadata)resolve.second).getKey()).bold()).nbsp().append("[" + ((UIThemeMetadata)resolve.first).getName() + "]").br().append(StringUtil.notNullize((String)((UIThemeMetadata.UIKeyMetadata)resolve.second).getDescription())).toString();
    }

    @Nls
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        String since;
        Pair<UIThemeMetadata, UIThemeMetadata.UIKeyMetadata> resolve = ThemeJsonDocumentationProvider.resolve(element);
        if (resolve == null) {
            return null;
        }
        UIThemeMetadata uiThemeMetadata = (UIThemeMetadata)resolve.first;
        UIThemeMetadata.UIKeyMetadata uiKeyMetadata = (UIThemeMetadata.UIKeyMetadata)resolve.second;
        HtmlBuilder builder2 = new HtmlBuilder();
        HtmlBuilder definitionBuilder = new HtmlBuilder();
        definitionBuilder.append((HtmlChunk)HtmlChunk.text((String)uiKeyMetadata.getKey()).bold());
        definitionBuilder.br().append("[").append(uiThemeMetadata.getName()).append("] - ");
        definitionBuilder.append("[").append(uiThemeMetadata.getPluginId()).append("]");
        HtmlChunk.Element definition = definitionBuilder.wrapWith("pre").wrapWith(DocumentationMarkup.DEFINITION_ELEMENT);
        builder2.append((HtmlChunk)definition);
        HtmlBuilder contentBuilder = new HtmlBuilder();
        if (uiKeyMetadata.isDeprecated()) {
            contentBuilder.append((HtmlChunk)HtmlChunk.text((String)DevKitThemesBundle.message("theme.json.documentation.key.deprecated", new Object[0])).bold().wrapWith(HtmlChunk.font((String)("#" + ColorUtil.toHex((Color)JBColor.RED))))).append((HtmlChunk)HtmlChunk.br());
        }
        contentBuilder.append(HtmlChunk.text((String)StringUtil.notNullize((String)uiKeyMetadata.getDescription(), (String)DevKitThemesBundle.message("theme.json.documentation.key.no.description", new Object[0]))));
        contentBuilder.append((HtmlChunk)HtmlChunk.br()).append((HtmlChunk)HtmlChunk.br());
        HtmlChunk.Element content = contentBuilder.wrapWith(DocumentationMarkup.CONTENT_ELEMENT);
        builder2.append((HtmlChunk)content);
        HtmlBuilder sectionsBuilder = new HtmlBuilder();
        String source = uiKeyMetadata.getSource();
        if (source != null) {
            ThemeJsonDocumentationProvider.appendSection(sectionsBuilder, DevKitThemesBundle.message("theme.json.documentation.section.source.title", new Object[0]), () -> {
                PsiClassType type = JavaPsiFacade.getElementFactory((Project)element.getProject()).createTypeByFQClassName(source);
                StringBuilder typeBuilder = new StringBuilder();
                JavaDocInfoGeneratorFactory.create((Project)element.getProject(), null).generateType(typeBuilder, (PsiType)type, element);
                return typeBuilder.toString();
            });
        }
        if ((since = uiKeyMetadata.getSince()) != null) {
            ThemeJsonDocumentationProvider.appendSection(sectionsBuilder, DevKitThemesBundle.message("theme.json.documentation.section.since.title", new Object[0]), since);
        }
        HtmlChunk.Element sections = sectionsBuilder.wrapWith(DocumentationMarkup.SECTIONS_TABLE);
        builder2.append((HtmlChunk)sections);
        return builder2.toString();
    }

    private static void appendSection(HtmlBuilder builder2, @Nls String sectionName, @Nls String sectionContent) {
        ThemeJsonDocumentationProvider.appendSection(builder2, sectionName, () -> sectionContent);
    }

    private static void appendSection(HtmlBuilder builder2, @Nls String sectionName, Supplier<@Nls String> content) {
        HtmlChunk.Element headerCell = DocumentationMarkup.SECTION_HEADER_CELL.child((HtmlChunk)HtmlChunk.text((String)sectionName).wrapWith("p"));
        HtmlChunk.Element contentCell = DocumentationMarkup.SECTION_CONTENT_CELL.addText(content.get());
        builder2.append((HtmlChunk)HtmlChunk.tag((String)"tr").children(new HtmlChunk[]{headerCell, contentCell}));
    }

    @Nullable
    private static Pair<UIThemeMetadata, UIThemeMetadata.UIKeyMetadata> resolve(PsiElement element) {
        if (!(element instanceof JsonProperty)) {
            return null;
        }
        if (!ThemeJsonUtil.isThemeFilename(element.getContainingFile().getName())) {
            return null;
        }
        return ThemeJsonUtil.findMetadata((JsonProperty)element);
    }
}

