/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.themes;

import com.intellij.ide.ui.UIThemeProvider;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.themes.metadata.UIThemeMetadataService;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class ThemeEPPathReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue().withLocalName(new String[]{"path"}), new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (!PsiUtil.isPluginXmlPsiElement(element)) {
                    return PsiReference.EMPTY_ARRAY;
                }
                XmlTag tag = ((XmlAttribute)element.getParent()).getParent();
                DomElement domElement = DomManager.getDomManager((Project)element.getProject()).getDomElement(tag);
                if (!(domElement instanceof Extension)) {
                    return PsiReference.EMPTY_ARRAY;
                }
                ExtensionPoint extensionPoint = ((Extension)domElement).getExtensionPoint();
                if (extensionPoint == null) {
                    return PsiReference.EMPTY_ARRAY;
                }
                String extensionPointQualifiedName = extensionPoint.getEffectiveQualifiedName();
                if (!UIThemeProvider.EP_NAME.getName().equals(extensionPointQualifiedName) && !UIThemeMetadataService.EP_NAME.getName().equals(extensionPointQualifiedName)) {
                    return PsiReference.EMPTY_ARRAY;
                }
                return new FileReferenceSet(element).getAllReferences();
            }
        });
    }
}

