/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.themes;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.ide.ui.UIThemeMetadata;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.themes.DevKitThemesBundle;
import org.jetbrains.idea.devkit.themes.ThemeJsonUtil;

public class ThemeAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (!(element instanceof JsonProperty)) {
            return;
        }
        if (!ThemeJsonUtil.isThemeFilename(holder.getCurrentAnnotationSession().getFile().getName())) {
            return;
        }
        JsonProperty property = (JsonProperty)element;
        if (property.getValue() instanceof JsonObject) {
            return;
        }
        if (!ThemeJsonUtil.isInsideUiProperty(property)) {
            return;
        }
        Pair<UIThemeMetadata, UIThemeMetadata.UIKeyMetadata> pair = ThemeJsonUtil.findMetadata(property);
        if (pair == null) {
            String parentNames = ThemeJsonUtil.getParentNames(property);
            if (parentNames.startsWith("*")) {
                return;
            }
            String fullKey = parentNames.isEmpty() ? property.getName() : parentNames + "." + property.getName();
            holder.newAnnotation(HighlightSeverity.WARNING, DevKitThemesBundle.message("theme.highlighting.unresolved.key", fullKey)).range((PsiElement)property.getNameElement()).highlightType(ProblemHighlightType.WARNING).create();
            return;
        }
        if (((UIThemeMetadata.UIKeyMetadata)pair.second).isDeprecated()) {
            holder.newAnnotation(HighlightSeverity.WARNING, DevKitThemesBundle.message("theme.highlighting.deprecated.key", ((UIThemeMetadata.UIKeyMetadata)pair.second).getKey())).range((PsiElement)property.getNameElement()).highlightType(ProblemHighlightType.LIKE_DEPRECATED).create();
        }
    }
}

