/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant.vfs;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.dummy.DummyCachingFileSystem;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.testAssistant.vfs.TestDataGroupVirtualFile;

public class TestDataGroupFileSystem
extends DummyCachingFileSystem<VirtualFile> {
    @NonNls
    private static final String GROUP_FILES_SEPARATOR = "33d0ee30-8c8f-11e7-bb31-be2e44b06b34";
    @NonNls
    private static final String PROTOCOL = "testdata";

    public TestDataGroupFileSystem() {
        super(PROTOCOL);
    }

    public static TestDataGroupFileSystem getTestDataGroupFileSystem() {
        return (TestDataGroupFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    public static String getPath(VirtualFile beforeFile, VirtualFile afterFile) {
        return beforeFile.getPath() + GROUP_FILES_SEPARATOR + afterFile.getPath();
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        String[] parts = path.split(GROUP_FILES_SEPARATOR);
        if (parts.length != 2) {
            return super.extractPresentableUrl(path);
        }
        return FileUtil.getLocationRelativeToUserHome((String)parts[0]) + "\n" + FileUtil.getLocationRelativeToUserHome((String)parts[1]);
    }

    protected VirtualFile findFileByPathInner(@NotNull String path) {
        String[] parts = path.split(GROUP_FILES_SEPARATOR);
        if (parts.length != 2) {
            return null;
        }
        String beforePath = parts[0];
        String afterPath = parts[1];
        if (StringUtil.isEmpty((String)beforePath) || StringUtil.isEmpty((String)afterPath)) {
            return null;
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        VirtualFile beforeFile = localFileSystem.refreshAndFindFileByPath(beforePath);
        VirtualFile afterFile = localFileSystem.refreshAndFindFileByPath(afterPath);
        if (beforeFile == null || afterFile == null) {
            return null;
        }
        return new TestDataGroupVirtualFile(beforeFile, afterFile);
    }
}

