/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.testAssistant.TestDataFile;
import org.jetbrains.idea.devkit.testAssistant.TestDataNavigationElement;
import org.jetbrains.idea.devkit.testAssistant.TestDataUtil;
import org.jetbrains.idea.devkit.testAssistant.vfs.TestDataGroupVirtualFile;

public final class TestDataNavigationElementFactory {
    private static final int CREATE_MISSING_FILES_WITHOUT_CONFIRMATION_LIMIT = 3;

    private TestDataNavigationElementFactory() {
    }

    @NotNull
    public static TestDataNavigationElement createForNonExistingFile(@NotNull Project project, @NotNull TestDataFile path) {
        return new NonExistingTestDataFileNavigationElement(project, path);
    }

    @NotNull
    public static TestDataNavigationElement createForFile(@NotNull Project project, @NotNull TestDataFile file) {
        return new TestDataFileNavigationElement(project, file);
    }

    @NotNull
    public static TestDataNavigationElement createForGroup(@NotNull Project project, @NotNull TestDataGroupVirtualFile group) {
        return new TestDataGroupNavigationElement(project, group);
    }

    @NotNull
    public static TestDataNavigationElement createForCreateMissingFilesOption(@NotNull List<TestDataFile> filePaths) {
        return new CreateMissingTestDataFilesNavigationElement(filePaths);
    }

    private static final class NonExistingTestDataFileNavigationElement
    implements TestDataNavigationElement {
        private final Project myProject;
        private final TestDataFile myPath;

        private NonExistingTestDataFileNavigationElement(@NotNull Project project, @NotNull TestDataFile path) {
            this.myProject = project;
            this.myPath = path;
        }

        @Override
        public void performAction(@NotNull Project project) {
            TestDataUtil.openOrAskToCreateFile(project, this.myPath);
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return FileTypes.UNKNOWN.getIcon();
        }

        @Override
        @NotNull
        public List<Pair<String, SimpleTextAttributes>> getTitleFragments() {
            Pair<String, String> relativePath = TestDataUtil.getRelativePathPairForMissingFile(this.myProject, this.myPath.getPath());
            Object[] elements = new Pair[]{new Pair((Object)(this.myPath.getName() + FontUtil.spaceAndThinSpace()), (Object)SimpleTextAttributes.GRAYED_ATTRIBUTES), new Pair((Object)(relativePath.first == null ? "" : (String)relativePath.first), (Object)SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES), new Pair(relativePath.first == null ? "" : "/" + (String)relativePath.second, (Object)SimpleTextAttributes.GRAYED_ATTRIBUTES)};
            return new SmartList(elements);
        }
    }

    private static final class TestDataFileNavigationElement
    implements TestDataNavigationElement {
        private final Project myProject;
        private final TestDataFile myFile;

        private TestDataFileNavigationElement(@NotNull Project project, @NotNull TestDataFile file) {
            this.myProject = project;
            this.myFile = file;
        }

        @Override
        public void performAction(@NotNull Project project) {
            TestDataUtil.openOrAskToCreateFile(project, this.myFile);
        }

        @Override
        @Nullable
        public Icon getIcon() {
            VirtualFile file = this.myFile.getVirtualFile();
            assert (file != null);
            return file.getFileType().getIcon();
        }

        @Override
        @NotNull
        public List<Pair<String, SimpleTextAttributes>> getTitleFragments() {
            VirtualFile file = this.myFile.getVirtualFile();
            assert (file != null);
            Pair<String, String> relativePath = TestDataUtil.getModuleOrProjectRelativeParentPath(this.myProject, this.myFile.getVirtualFile());
            if (relativePath == null) {
                return new SmartList((Object)new Pair((Object)String.format("%s (%s)", this.myFile.getName(), file.getParent().getPath() + "/"), (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
            }
            return new SmartList((Object[])new Pair[]{new Pair((Object)(this.myFile.getName() + FontUtil.spaceAndThinSpace()), (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES), new Pair((Object)((String)relativePath.first), (Object)SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES), new Pair((Object)("/" + (String)relativePath.second), (Object)SimpleTextAttributes.GRAYED_ATTRIBUTES)});
        }
    }

    private static final class TestDataGroupNavigationElement
    implements TestDataNavigationElement {
        private final Project myProject;
        private final TestDataGroupVirtualFile myGroup;

        private TestDataGroupNavigationElement(Project project, TestDataGroupVirtualFile group) {
            this.myProject = project;
            this.myGroup = group;
        }

        @Override
        public void performAction(@NotNull Project project) {
            PsiNavigationSupport.getInstance().createNavigatable(project, (VirtualFile)this.myGroup, -1).navigate(true);
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return AllIcons.Nodes.TestSourceFolder;
        }

        @Override
        @NotNull
        public List<Pair<String, SimpleTextAttributes>> getTitleFragments() {
            VirtualFile beforeFile = this.myGroup.getBeforeFile();
            VirtualFile afterFile = this.myGroup.getAfterFile();
            String beforeName = beforeFile.getName();
            String afterName = afterFile.getName();
            ArrayList<Pair<String, SimpleTextAttributes>> result = new ArrayList<Pair<String, SimpleTextAttributes>>();
            result.add(new Pair((Object)(TestDataUtil.getGroupDisplayName(beforeName, afterName) + " ("), (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
            Pair<String, String> beforeRelativePath = TestDataUtil.getModuleOrProjectRelativeParentPath(this.myProject, beforeFile);
            Pair<String, String> afterRelativePath = TestDataUtil.getModuleOrProjectRelativeParentPath(this.myProject, afterFile);
            if (beforeRelativePath != null && afterRelativePath != null) {
                String beforeBase = (String)beforeRelativePath.getFirst();
                String afterBase = (String)afterRelativePath.getFirst();
                String beforeBaseRelativePath = (String)beforeRelativePath.getSecond();
                String afterBaseRelativePath = (String)afterRelativePath.getSecond();
                if (beforeBase.equals(afterBase)) {
                    result.add((Pair<String, SimpleTextAttributes>)new Pair((Object)beforeBase, (Object)SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES));
                    if (beforeBaseRelativePath.equals(afterBaseRelativePath)) {
                        result.add((Pair<String, SimpleTextAttributes>)new Pair((Object)("/" + beforeBaseRelativePath + "/)"), (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
                    } else {
                        result.add((Pair<String, SimpleTextAttributes>)new Pair((Object)"/", (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
                        String commonPrefix = StringUtil.commonPrefix((String)beforeBaseRelativePath, (String)afterBaseRelativePath);
                        if (!commonPrefix.isEmpty()) {
                            result.add((Pair<String, SimpleTextAttributes>)new Pair((Object)commonPrefix, (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
                        }
                        String beforeUniqueSuffix = beforeBaseRelativePath.substring(commonPrefix.length());
                        String afterUniqueSuffix = afterBaseRelativePath.substring(commonPrefix.length());
                        result.add((Pair<String, SimpleTextAttributes>)new Pair((Object)("<" + beforeUniqueSuffix + "/, " + afterUniqueSuffix + "/>"), (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
                    }
                } else {
                    result.add((Pair<String, SimpleTextAttributes>)new Pair((Object)beforeBase, (Object)SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES));
                    result.add((Pair<String, SimpleTextAttributes>)new Pair((Object)("/" + beforeBaseRelativePath + "/, "), (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
                    result.add((Pair<String, SimpleTextAttributes>)new Pair((Object)afterBase, (Object)SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES));
                    result.add((Pair<String, SimpleTextAttributes>)new Pair((Object)("/" + afterBaseRelativePath + "/"), (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
                }
            }
            return result;
        }
    }

    private static final class CreateMissingTestDataFilesNavigationElement
    implements TestDataNavigationElement {
        private final List<TestDataFile> myFilePaths;

        private CreateMissingTestDataFilesNavigationElement(List<TestDataFile> filePaths) {
            this.myFilePaths = filePaths;
        }

        @Override
        public void performAction(@NotNull Project project) {
            HashSet<String> filePathsToCreate = new HashSet<String>();
            for (TestDataFile testDataFile : this.myFilePaths) {
                VirtualFile vFile = testDataFile.getVirtualFile();
                if (vFile != null && vFile.isValid()) continue;
                filePathsToCreate.add(testDataFile.getPath());
            }
            if (filePathsToCreate.size() > 3) {
                ArrayList<String> displayPaths = new ArrayList<String>();
                for (String path2 : filePathsToCreate) {
                    displayPaths.add(TestDataUtil.getHtmlDisplayPathForMissingFile(project, path2));
                }
                displayPaths.sort(String.CASE_INSENSITIVE_ORDER);
                String string = StringUtil.join(displayPaths, (String)"\n");
                int code = Messages.showOkCancelDialog((Project)project, (String)DevKitBundle.message("testdata.confirm.create.missing.files.dialog.message", string), (String)DevKitBundle.message("testdata.create.missing.files", new Object[0]), (Icon)Messages.getQuestionIcon());
                if (code != 0) {
                    return;
                }
            }
            filePathsToCreate.forEach(path -> TestDataUtil.createFileAndNavigate(project, path));
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        @NotNull
        public List<Pair<String, SimpleTextAttributes>> getTitleFragments() {
            return Collections.singletonList(new Pair((Object)DevKitBundle.message("testdata.create.missing.files", new Object[0]), (Object)SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES));
        }
    }
}

