/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.CommonProcessors;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FindSymbolParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.testAssistant.TestDataFile;
import org.jetbrains.idea.devkit.testAssistant.TestDataLineMarkerProvider;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public final class TestDataGuessByExistingFilesUtil {
    private static final Logger LOG = Logger.getInstance(TestDataGuessByExistingFilesUtil.class);

    private TestDataGuessByExistingFilesUtil() {
    }

    @NotNull
    static List<TestDataFile> collectTestDataByExistingFiles(@NotNull PsiMethod psiMethod, @Nullable String testDataPath) {
        Application application = ApplicationManager.getApplication();
        if (!application.isUnitTestMode() && application.isHeadlessEnvironment()) {
            LOG.warn("Collecting testdata by existing files called in headless environment and not-unit testing mode");
            return Collections.emptyList();
        }
        return (List)ReadAction.compute(() -> TestDataGuessByExistingFilesUtil.buildDescriptorFromExistingTestData(psiMethod, testDataPath).restoreFiles());
    }

    @NotNull
    static List<TestDataFile> guessTestDataName(PsiMethod method) {
        String testName = TestDataGuessByExistingFilesUtil.getTestName(method);
        if (testName == null) {
            return Collections.emptyList();
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return Collections.emptyList();
        }
        String testDataBasePath = TestDataLineMarkerProvider.getTestDataBasePath(psiClass);
        int count = 5;
        PsiMethod prev = (PsiMethod)PsiTreeUtil.getPrevSiblingOfType((PsiElement)method, PsiMethod.class);
        while (prev != null && count-- > 0) {
            List<TestDataFile> testData = TestDataGuessByExistingFilesUtil.guessTestDataBySiblingTest(prev, testDataBasePath, testName);
            if (!testData.isEmpty()) {
                return testData;
            }
            prev = (PsiMethod)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prev, PsiMethod.class);
        }
        count = 5;
        PsiMethod next = (PsiMethod)PsiTreeUtil.getNextSiblingOfType((PsiElement)method, PsiMethod.class);
        while (next != null && count-- > 0) {
            List<TestDataFile> testData = TestDataGuessByExistingFilesUtil.guessTestDataBySiblingTest(next, testDataBasePath, testName);
            if (!testData.isEmpty()) {
                return testData;
            }
            next = (PsiMethod)PsiTreeUtil.getNextSiblingOfType((PsiElement)next, PsiMethod.class);
        }
        return Collections.emptyList();
    }

    @NotNull
    private static List<TestDataFile> guessTestDataBySiblingTest(PsiMethod psiMethod, String testDataBasePath, String testName) {
        return TestDataGuessByExistingFilesUtil.buildDescriptorFromExistingTestData(psiMethod, testDataBasePath).generateByTemplates(testName, null);
    }

    @Nullable
    private static String getTestName(@NotNull PsiMethod method) {
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)method, PsiClass.class);
        if (psiClass == null) {
            return null;
        }
        TestFramework framework = TestFrameworks.detectFramework((PsiClass)psiClass);
        if (framework == null || !framework.isTestMethod((PsiElement)method)) {
            return null;
        }
        return TestDataGuessByExistingFilesUtil.getTestName(method.getName());
    }

    @NotNull
    public static String getTestName(@NotNull String methodName) {
        return StringUtil.trimStart((String)methodName, (String)"test");
    }

    @NotNull
    private static TestDataDescriptor buildDescriptorFromExistingTestData(@NotNull PsiMethod method, @Nullable String testDataPath) {
        return (TestDataDescriptor)CachedValuesManager.getCachedValue((PsiElement)method, () -> new CachedValueProvider.Result((Object)TestDataGuessByExistingFilesUtil.buildDescriptor(method, testDataPath), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @NotNull
    private static TestDataDescriptor buildDescriptor(@NotNull PsiMethod psiMethod, @Nullable String testDataPath) {
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiMethod, PsiClass.class);
        String testName = TestDataGuessByExistingFilesUtil.getTestName(psiMethod);
        if (testName == null || psiClass == null) {
            return TestDataDescriptor.NOTHING_FOUND;
        }
        return TestDataGuessByExistingFilesUtil.buildDescriptor(testName, psiClass, testDataPath);
    }

    public static List<TestDataFile> suggestTestDataFiles(@NotNull String testName, String testDataPath, @NotNull PsiClass psiClass) {
        return TestDataGuessByExistingFilesUtil.buildDescriptor(testName, psiClass, testDataPath).restoreFiles();
    }

    @NotNull
    private static TestDataDescriptor buildDescriptor(@NotNull String testName, @NotNull PsiClass psiClass, @Nullable String testDataPath) {
        String normalizedTestDataPath = testDataPath == null ? null : StringUtil.trimEnd((String)StringUtil.trimEnd((String)testDataPath, (String)"/"), (String)"\\");
        String possibleFileName = (String)ContainerUtil.getLastItem((List)StringUtil.split((String)testName, (String)"$"), (Object)testName);
        assert (possibleFileName != null);
        if (possibleFileName.isEmpty()) {
            return TestDataDescriptor.NOTHING_FOUND;
        }
        Project project = psiClass.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        GotoFileModel gotoModel = new GotoFileModel(project);
        String possibleFilePath = testName.replace('$', '/');
        HashMap<String, SmartList> descriptorsByFileNames = new HashMap<String, SmartList>();
        Module module = (Module)ReadAction.compute(() -> ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass));
        Collection<String> fileNames = TestDataGuessByExistingFilesUtil.getAllFileNames(possibleFileName, gotoModel);
        ProgressIndicator indicator = EmptyProgressIndicator.notNullize((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator());
        indicator.setText(DevKitBundle.message("testdata.progress.text.searching.for.test.data.files", testName));
        indicator.setIndeterminate(false);
        int fileNamesCount = fileNames.size();
        double currentIndex = 0.0;
        for (String name : fileNames) {
            Object[] elements;
            ProgressManager.checkCanceled();
            for (Object element : elements = gotoModel.getElementsByName(name, false, name)) {
                String fileName;
                int i;
                String filePath;
                VirtualFile file;
                VirtualFile directoryVirtualFile;
                String normalizedDirPath;
                PsiFileSystemItem containingDirectory;
                if (!(element instanceof PsiFileSystemItem)) continue;
                PsiFileSystemItem psiFile = (PsiFileSystemItem)element;
                if (normalizedTestDataPath != null && (containingDirectory = psiFile.getParent()) != null && !(normalizedDirPath = StringUtil.trimEnd((String)StringUtil.trimEnd((String)(directoryVirtualFile = containingDirectory.getVirtualFile()).getPath(), (String)"/"), (String)"\\")).startsWith(normalizedTestDataPath) || (file = psiFile.getVirtualFile()) == null || fileIndex.isInSource(file) && !fileIndex.isUnderSourceRootOfType(file, JavaModuleSourceRootTypes.RESOURCES) || !StringUtil.containsIgnoreCase((String)(filePath = file.getPath()), (String)possibleFilePath) && !StringUtil.containsIgnoreCase((String)filePath, (String)testName) || (i = (fileName = StringUtil.toLowerCase((String)PathUtil.getFileName((String)filePath))).indexOf(StringUtil.toLowerCase((String)possibleFileName))) < 0 || i + possibleFileName.length() < fileName.length() && Character.isDigit(fileName.charAt(i + possibleFileName.length()))) continue;
                SmartList currentDescriptors = new SmartList();
                VfsUtilCore.processFilesRecursively((VirtualFile)file, arg_0 -> TestDataGuessByExistingFilesUtil.lambda$buildDescriptor$3(possibleFileName, project, module, (List)currentDescriptors, arg_0));
                if (currentDescriptors.isEmpty()) continue;
                List previousDescriptors = (List)descriptorsByFileNames.get(name);
                if (previousDescriptors == null) {
                    descriptorsByFileNames.put(name, currentDescriptors);
                    continue;
                }
                if (!TestDataGuessByExistingFilesUtil.moreRelevantPath((TestLocationDescriptor)currentDescriptors.get(0), (TestLocationDescriptor)previousDescriptors.get(0), psiClass)) continue;
                descriptorsByFileNames.put(name, currentDescriptors);
            }
            indicator.setFraction((currentIndex += 1.0) / (double)fileNamesCount);
        }
        List descriptors = ContainerUtil.flatten(descriptorsByFileNames.values());
        TestDataGuessByExistingFilesUtil.filterDirsFromOtherModules(descriptors);
        return new TestDataDescriptor(descriptors);
    }

    private static Collection<String> getAllFileNames(final String testName, GotoFileModel model) {
        CommonProcessors.CollectProcessor<String> processor = new CommonProcessors.CollectProcessor<String>(){

            public boolean accept(String name) {
                ProgressManager.checkCanceled();
                return StringUtil.containsIgnoreCase((String)name, (String)testName);
            }
        };
        model.processNames((Processor)processor, FindSymbolParameters.simple((Project)model.getProject(), (boolean)false));
        return processor.getResults();
    }

    private static void filterDirsFromOtherModules(List<TestLocationDescriptor> descriptorsByFileNames) {
        if (descriptorsByFileNames.size() < 2) {
            return;
        }
        if (!ContainerUtil.exists(descriptorsByFileNames, descriptor -> descriptor.isFromCurrentModule)) {
            return;
        }
        descriptorsByFileNames.removeIf(d -> !d.isFromCurrentModule);
    }

    @Nullable
    private static String getSimpleClassName(@NotNull PsiClass psiClass) {
        String result = psiClass.getQualifiedName();
        if (result == null) {
            return null;
        }
        int i = (result = StringUtil.trimEnd((String)result, (String)"Test")).lastIndexOf(46);
        if (i >= 0) {
            result = result.substring(i + 1);
        }
        return result;
    }

    private static boolean moreRelevantPath(@NotNull TestLocationDescriptor candidate, @NotNull TestLocationDescriptor current, @NotNull PsiClass psiClass) {
        boolean currentMatched;
        String packageAsPath;
        boolean candidateMatched;
        String className = psiClass.getQualifiedName();
        if (className == null) {
            return false;
        }
        int lastDotIndex = className.lastIndexOf(".");
        String candidateLcDir = StringUtil.toLowerCase((String)candidate.pathPrefix);
        String currentLcDir = StringUtil.toLowerCase((String)current.pathPrefix);
        if (lastDotIndex >= 0 && (candidateMatched = candidateLcDir.contains(packageAsPath = StringUtil.toLowerCase((String)className.substring(0, lastDotIndex).replace('.', '/')))) ^ (currentMatched = currentLcDir.contains(packageAsPath))) {
            return candidateMatched;
        }
        String simpleName = TestDataGuessByExistingFilesUtil.getSimpleClassName(psiClass);
        if (simpleName == null) {
            return false;
        }
        String pattern = StringUtil.toLowerCase((String)simpleName);
        candidateMatched = candidateLcDir.contains(pattern);
        if (candidateMatched ^ (currentMatched = currentLcDir.contains(pattern))) {
            return candidateMatched;
        }
        String[] words = NameUtil.nameToWords((String)simpleName);
        int candidateWordsMatched = 0;
        int currentWordsMatched = 0;
        int candidateMatchPosition = -1;
        int currentMatchPosition = -1;
        StringBuilder currentNameSubstringSb = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            int currentWordsIndex;
            currentNameSubstringSb.append(words[i]);
            String currentNameLcSubstring = StringUtil.toLowerCase((String)currentNameSubstringSb.toString());
            int candidateWordsIndex = candidateLcDir.lastIndexOf(currentNameLcSubstring);
            if (candidateWordsIndex > 0) {
                candidateWordsMatched = i + 1;
                candidateMatchPosition = candidateWordsIndex;
            }
            if ((currentWordsIndex = currentLcDir.lastIndexOf(currentNameLcSubstring)) > 0) {
                currentWordsMatched = i + 1;
                currentMatchPosition = currentWordsIndex;
            }
            if (candidateWordsMatched != currentWordsMatched) break;
        }
        if (candidateWordsMatched != currentWordsMatched) {
            return candidateWordsMatched > currentWordsMatched;
        }
        return candidateMatchPosition > currentMatchPosition;
    }

    private static /* synthetic */ boolean lambda$buildDescriptor$3(String possibleFileName, Project project, Module module, List currentDescriptors, VirtualFile f) {
        if (f.isDirectory()) {
            return true;
        }
        TestLocationDescriptor current = TestLocationDescriptor.create(possibleFileName, f, project, module);
        if (current != null) {
            currentDescriptors.add(current);
        }
        return true;
    }

    private static class TestDataDescriptor {
        private static final TestDataDescriptor NOTHING_FOUND = new TestDataDescriptor(Collections.emptyList());
        private final List<TestLocationDescriptor> myDescriptors = new ArrayList<TestLocationDescriptor>();

        TestDataDescriptor(Collection<TestLocationDescriptor> descriptors) {
            this.myDescriptors.addAll(descriptors);
        }

        @NotNull
        public List<TestDataFile> restoreFiles() {
            return ContainerUtil.mapNotNull(this.myDescriptors, d -> {
                PsiFile file = (PsiFile)ReadAction.compute(() -> (PsiFile)d.filePointer.getElement());
                return file == null ? null : new TestDataFile.Existing(file.getVirtualFile());
            });
        }

        @NotNull
        public List<TestDataFile> generateByTemplates(@NotNull String testName, @Nullable String root) {
            ArrayList<TestDataFile> result = new ArrayList<TestDataFile>();
            if (StringUtil.isEmpty((String)testName)) {
                return result;
            }
            for (TestLocationDescriptor descriptor : this.myDescriptors) {
                if (root != null && !descriptor.pathPrefix.startsWith(root)) continue;
                result.add(new TestDataFile.NonExisting(descriptor.pathPrefix + (descriptor.startWithLowerCase ? StringUtil.decapitalize((String)testName) : StringUtil.capitalize((String)testName)) + descriptor.pathSuffix));
            }
            return result;
        }

        public String toString() {
            return this.myDescriptors.toString();
        }
    }

    private static final class TestLocationDescriptor {
        final String pathPrefix;
        final String pathSuffix;
        final boolean startWithLowerCase;
        final boolean isFromCurrentModule;
        private final SmartPsiElementPointer<PsiFile> filePointer;

        private TestLocationDescriptor(String pathPrefix, String pathSuffix, boolean startWithLowerCase, boolean isFromCurrentModule, SmartPsiElementPointer<PsiFile> filePointer) {
            this.pathPrefix = pathPrefix;
            this.pathSuffix = pathSuffix;
            this.startWithLowerCase = startWithLowerCase;
            this.isFromCurrentModule = isFromCurrentModule;
            this.filePointer = filePointer;
        }

        static TestLocationDescriptor create(@NotNull String testName, @NotNull VirtualFile matched, @NotNull Project project, @Nullable Module module) {
            PsiFile file;
            boolean startWithLowerCase;
            if (testName.isEmpty()) {
                return null;
            }
            String path = matched.getPath();
            int idx = StringUtil.indexOf((CharSequence)path, (CharSequence)testName);
            boolean capitalized = StringUtil.isCapitalized((String)testName);
            if (idx < 0) {
                testName = capitalized ? StringUtil.decapitalize((String)testName) : StringUtil.capitalize((String)testName);
                idx = StringUtil.indexOf((CharSequence)path, (CharSequence)testName);
                if (idx < 0) {
                    return null;
                }
                startWithLowerCase = capitalized;
            } else {
                startWithLowerCase = !capitalized;
            }
            String pathPrefix = path.substring(0, idx);
            String pathSuffix = path.substring(idx + testName.length());
            boolean isFromCurrentModule = false;
            if (module != null) {
                isFromCurrentModule = module.equals(ModuleUtilCore.findModuleForFile((VirtualFile)matched, (Project)project));
            }
            if ((file = PsiManager.getInstance((Project)project).findFile(matched)) == null) {
                return null;
            }
            return new TestLocationDescriptor(pathPrefix, pathSuffix, startWithLowerCase, isFromCurrentModule, (SmartPsiElementPointer<PsiFile>)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)file));
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.pathPrefix != null ? this.pathPrefix.hashCode() : 0);
            result = 31 * result + (this.pathSuffix != null ? this.pathSuffix.hashCode() : 0);
            result = 31 * result + (this.startWithLowerCase ? 1 : 0);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestLocationDescriptor that = (TestLocationDescriptor)o;
            if (this.startWithLowerCase != that.startWithLowerCase) {
                return false;
            }
            if (!Objects.equals(this.pathPrefix, that.pathPrefix)) {
                return false;
            }
            return Objects.equals(this.pathSuffix, that.pathSuffix);
        }

        public String toString() {
            return String.format("%s[...]%s", this.pathPrefix, this.pathSuffix);
        }
    }
}

