/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.testAssistant.NavigateToTestDataAction;
import org.jetbrains.idea.devkit.testAssistant.TestDataFile;
import org.jetbrains.idea.devkit.testAssistant.TestDataRelatedItem;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

public class TestDataAsRelatedFileProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull DataContext context) {
        PsiClass ctxElement;
        Editor editor = (Editor)context.getData(CommonDataKeys.EDITOR);
        Project project = (Project)context.getData(CommonDataKeys.PROJECT);
        PsiElement element = (PsiElement)context.getData(CommonDataKeys.PSI_ELEMENT);
        if (editor == null || element == null || project == null) {
            return Collections.emptyList();
        }
        UMethod uMethod = (UMethod)UastContextKt.getUastParentOfType((PsiElement)element, UMethod.class);
        Object object = ctxElement = uMethod == null ? NavigateToTestDataAction.findParametrizedClass(context) : uMethod.getSourcePsi();
        if (ctxElement == null) {
            return Collections.emptyList();
        }
        List<TestDataFile> testDataFiles = NavigateToTestDataAction.findTestDataFiles(context, project, false);
        return testDataFiles.isEmpty() ? Collections.emptyList() : Collections.singletonList(new TestDataRelatedItem((PsiElement)ctxElement, editor, testDataFiles));
    }
}

