/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.execution.Location;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.testAssistant.TestLocationUtil;

final class TestCaseAsRelatedFileProvider
extends GotoRelatedProvider {
    TestCaseAsRelatedFileProvider() {
    }

    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull DataContext context) {
        Editor editor = (Editor)context.getData(CommonDataKeys.EDITOR);
        Project project = (Project)context.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)context.getData(CommonDataKeys.VIRTUAL_FILE);
        if (editor == null || file == null || project == null) {
            return Collections.emptyList();
        }
        List<Location> locations = TestLocationUtil.collectRelativeLocations(project, file);
        if (locations.isEmpty()) {
            return Collections.emptyList();
        }
        return ContainerUtil.map(locations, location -> new GotoRelatedItem(location.getPsiElement()));
    }
}

