/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationSingletonPolicy;
import com.intellij.execution.configurations.SimpleConfigurationType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.run.PluginRunConfiguration;

public final class PluginConfigurationType
extends SimpleConfigurationType {
    private static final String DEFAULT_PARAMETERS = "-Xmx512m -Xms256m -ea";

    public PluginConfigurationType() {
        super("#org.jetbrains.idea.devkit.run.PluginConfigurationType", DevKitBundle.message("run.configuration.title", new Object[0]), DevKitBundle.message("run.configuration.type.description", new Object[0]), NotNullLazyValue.createValue(() -> AllIcons.Nodes.Plugin));
    }

    @NotNull
    public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
        PluginRunConfiguration runConfiguration = new PluginRunConfiguration(project, (ConfigurationFactory)this, "");
        runConfiguration.VM_PARAMETERS = runConfiguration.VM_PARAMETERS == null ? DEFAULT_PARAMETERS : runConfiguration.VM_PARAMETERS + DEFAULT_PARAMETERS;
        return runConfiguration;
    }

    public boolean isApplicable(@NotNull Project project) {
        return ModuleUtil.hasModulesOfType((Project)project, (ModuleType)PluginModuleType.getInstance());
    }

    @NotNull
    public RunConfiguration createConfiguration(@Nullable String name, @NotNull RunConfiguration template) {
        PluginRunConfiguration pluginRunConfiguration = (PluginRunConfiguration)template;
        if (pluginRunConfiguration.getModule() == null) {
            Collection modules = ModuleUtil.getModulesOfType((Project)pluginRunConfiguration.getProject(), (ModuleType)PluginModuleType.getInstance());
            pluginRunConfiguration.setModule((Module)ContainerUtil.getFirstItem((Collection)modules));
        }
        return super.createConfiguration(name, (RunConfiguration)pluginRunConfiguration);
    }

    @NotNull
    public String getTag() {
        return "plugin";
    }

    public String getHelpTopic() {
        return "reference.dialogs.rundebug.devkit.PluginConfigurationType";
    }

    @NotNull
    public RunConfigurationSingletonPolicy getSingletonPolicy() {
        return RunConfigurationSingletonPolicy.SINGLE_INSTANCE_ONLY;
    }
}

