/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtilRt;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.run.JUnitDevKitPatcher;
import org.jetbrains.idea.devkit.util.PsiUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J5\u0010\u0007\u001a\u00020\b\"\f\b\u0000\u0010\t*\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0005\u001a\u0002H\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/devkit/run/DevKitApplicationPatcher;", "Lcom/intellij/execution/RunConfigurationExtension;", "()V", "isApplicableFor", "", "configuration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "updateJavaParameters", "", "T", "javaParameters", "Lcom/intellij/execution/configurations/JavaParameters;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/configurations/JavaParameters;Lcom/intellij/execution/configurations/RunnerSettings;)V", "intellij.devkit.core"})
public final class DevKitApplicationPatcher
extends RunConfigurationExtension {
    public <T extends RunConfigurationBase<?>> void updateJavaParameters(@NotNull T configuration, @NotNull JavaParameters javaParameters, @Nullable RunnerSettings runnerSettings) {
        boolean bl;
        String[] $this$none$iv;
        ParametersList vmParameters;
        block21: {
            String it;
            boolean bl2;
            boolean $i$f$none;
            List vmParametersAsList;
            block20: {
                String qualifiedName;
                ApplicationConfiguration applicationConfiguration = configuration instanceof ApplicationConfiguration ? (ApplicationConfiguration)configuration : null;
                if (applicationConfiguration == null) {
                    return;
                }
                ApplicationConfiguration applicationConfiguration2 = applicationConfiguration;
                Project project = applicationConfiguration2.getProject();
                if (!PsiUtil.isIdeaProject(project)) {
                    return;
                }
                vmParameters = javaParameters.getVMParametersList();
                boolean isDev = Intrinsics.areEqual((Object)((ApplicationConfiguration)configuration).getMainClassName(), (Object)"org.jetbrains.intellij.build.devServer.DevMainKt");
                vmParametersAsList = vmParameters.getList();
                if (vmParametersAsList.contains("--add-modules") || !isDev && !Intrinsics.areEqual((Object)((ApplicationConfiguration)configuration).getMainClassName(), (Object)"com.intellij.idea.Main")) {
                    return;
                }
                Module module = ((JavaRunConfigurationModule)((ApplicationConfiguration)configuration).getConfigurationModule()).getModule();
                Sdk sdk = JavaParameters.getJdkToRunModule((Module)module, (boolean)true);
                if (sdk == null) {
                    return;
                }
                Sdk jdk = sdk;
                if (!vmParameters.hasProperty("java.system.class.loader") && JUnitDevKitPatcher.loaderValid(project, module, qualifiedName = "com.intellij.util.lang.PathClassLoader")) {
                    vmParameters.addProperty("java.system.class.loader", qualifiedName);
                }
                if (!vmParametersAsList.contains("--add-opens")) {
                    JUnitDevKitPatcher.appendAddOpensWhenNeeded(project, jdk, vmParameters);
                }
                if (!isDev) {
                    return;
                }
                $this$none$iv = (String[])vmParametersAsList;
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object t : $this$none$iv) {
                        it = (String)t;
                        boolean bl3 = false;
                        if (!StringsKt.startsWith$default((String)it, (String)"-Xmx", (boolean)false, (int)2, null)) continue;
                        bl2 = false;
                        break block20;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                vmParameters.add("-Xmx2g");
            }
            $this$none$iv = vmParametersAsList;
            $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object t : $this$none$iv) {
                    it = (String)t;
                    boolean bl4 = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"-XX:ReservedCodeCacheSize", (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block21;
                }
                bl = true;
            }
        }
        if (bl) {
            vmParameters.add("-XX:ReservedCodeCacheSize=240m");
        }
        $this$none$iv = new String[]{"-XX:+UseG1GC", "-XX:SoftRefLRUPolicyMSPerMB=50", "-XX:MaxJavaStackTraceDepth=10000", "-ea", "-XX:CICompilerCount=2", "-XX:PrintIdealGraphLevel=3"};
        vmParameters.addAll($this$none$iv);
        if (!vmParameters.hasProperty("idea.config.path")) {
            String string;
            String productClassifier = vmParameters.getPropertyValue("idea.platform.prefix");
            String string2 = productClassifier;
            if (string2 == null) {
                string = "idea";
            } else if (Intrinsics.areEqual((Object)string2, (Object)"Idea")) {
                string = "idea-community";
            } else {
                String string3 = productClassifier.toLowerCase(Locale.ROOT);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            }
            productClassifier = string;
            vmParameters.addProperty("idea.config.path", FileUtilRt.toSystemIndependentName((String)(((ApplicationConfiguration)configuration).getWorkingDirectory() + "/out/dev-data/" + productClassifier + "/config")));
            vmParameters.addProperty("idea.system.path", FileUtilRt.toSystemIndependentName((String)(((ApplicationConfiguration)configuration).getWorkingDirectory() + "/out/dev-data/" + productClassifier + "/system")));
        }
        vmParameters.addProperty("sun.io.useCanonCaches", "false");
        vmParameters.addProperty("sun.awt.disablegrab", "true");
        vmParameters.addProperty("sun.java2d.metal", "true");
        vmParameters.addProperty("idea.debug.mode", "true");
        vmParameters.addProperty("idea.is.internal", "true");
        vmParameters.addProperty("fus.internal.test.mode", "true");
        vmParameters.addProperty("jbScreenMenuBar.enabled", "true");
        vmParameters.addProperty("apple.laf.useScreenMenuBar", "true");
        vmParameters.addProperty("jdk.attach.allowAttachSelf");
        vmParameters.addProperty("idea.initially.ask.config", "true");
    }

    public boolean isApplicableFor(@NotNull RunConfigurationBase<?> configuration) {
        return configuration instanceof ApplicationConfiguration;
    }
}

