/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references.extensions;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class ExtensionPointBinding {
    private final PsiClass myPsiClass;

    public ExtensionPointBinding(@NotNull PsiClass psiClass) {
        this.myPsiClass = psiClass;
    }

    public void visit(BindingVisitor visitor) {
        boolean hasClassLevelPropertyAnnotation = this.hasClassLevelPropertyAnnotation();
        for (PsiField field : this.myPsiClass.getAllFields()) {
            String tagName;
            PsiAnnotation attributeAnnotation;
            if (field.hasModifierProperty("static")) continue;
            PsiMethod getter = PropertyUtilBase.findGetterForField((PsiField)field);
            PsiMethod setter = PropertyUtilBase.findSetterForField((PsiField)field);
            if ((getter == null || setter == null) && !field.hasModifierProperty("public")) continue;
            PsiAnnotation requiredAnnotation = PsiUtil.findAnnotation(RequiredElement.class, new PsiMember[]{field, getter, setter});
            BindingVisitor.RequiredFlag required = BindingVisitor.RequiredFlag.NOT_REQUIRED;
            if (requiredAnnotation != null) {
                BindingVisitor.RequiredFlag requiredFlag = required = PsiUtil.getAnnotationBooleanAttribute(requiredAnnotation, "allowEmpty") ? BindingVisitor.RequiredFlag.REQUIRED_ALLOW_EMPTY : BindingVisitor.RequiredFlag.REQUIRED;
            }
            if ((attributeAnnotation = PsiUtil.findAnnotation(Attribute.class, new PsiMember[]{field, getter, setter})) != null) {
                String fieldName = PsiUtil.getAnnotationStringAttribute(attributeAnnotation, "value", field.getName());
                if (fieldName == null) continue;
                visitor.visitAttribute(field, fieldName, required);
                continue;
            }
            if (hasClassLevelPropertyAnnotation) {
                visitor.visitAttribute(field, field.getName(), required);
                continue;
            }
            PsiAnnotation tagAnno = PsiUtil.findAnnotation(Tag.class, new PsiMember[]{field, getter, setter});
            PsiAnnotation collectionAnnotation = PsiUtil.findAnnotation(XCollection.class, new PsiMember[]{field, getter, setter});
            String fieldName = field.getName();
            if (tagAnno != null) {
                tagName = PsiUtil.getAnnotationStringAttribute(tagAnno, "value", fieldName);
            } else {
                PsiAnnotation propAnno = PsiUtil.findAnnotation(Property.class, new PsiMember[]{field, getter, setter});
                String string = tagName = propAnno != null && PsiUtil.getAnnotationBooleanAttribute(propAnno, "surroundWithTag") ? "option" : null;
            }
            if (tagName != null && collectionAnnotation == null) {
                visitor.visitTagOrProperty(field, tagName, required);
                continue;
            }
            if (collectionAnnotation == null) continue;
            visitor.visitXCollection(field, tagName, collectionAnnotation, required);
        }
    }

    private boolean hasClassLevelPropertyAnnotation() {
        PsiAnnotation propertyAnnotation = this.myPsiClass.getAnnotation(Property.class.getName());
        if (propertyAnnotation == null) {
            return false;
        }
        PsiNameValuePair style = AnnotationUtil.findDeclaredAttribute((PsiAnnotation)propertyAnnotation, (String)"style");
        if (style == null) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)ObjectUtils.tryCast((Object)style.getDetachedValue(), PsiReferenceExpression.class);
        if (referenceExpression == null) {
            return false;
        }
        PsiEnumConstant enumConstant = (PsiEnumConstant)ObjectUtils.tryCast((Object)referenceExpression.resolve(), PsiEnumConstant.class);
        return enumConstant != null && enumConstant.getName().equals(Property.Style.ATTRIBUTE.name());
    }

    public static interface BindingVisitor {
        public void visitAttribute(@NotNull PsiField var1, @NotNull @NonNls String var2, RequiredFlag var3);

        public void visitTagOrProperty(@NotNull PsiField var1, @NotNull @NonNls String var2, RequiredFlag var3);

        public void visitXCollection(@NotNull PsiField var1, @Nullable @NonNls String var2, @NotNull PsiAnnotation var3, RequiredFlag var4);

        public static enum RequiredFlag {
            NOT_REQUIRED,
            REQUIRED,
            REQUIRED_ALLOW_EMPTY;

        }
    }
}

