/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationBuilder;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.SingletonNotificationManager;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.UastInjectionHostReferenceProvider;
import com.intellij.psi.UastReferenceProvider;
import com.intellij.psi.UastReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.references.ExtensionReferenceBase;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.uast.UExpression;

public class NotificationGroupIdReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, (ElementPattern)((UExpressionPattern)UastPatterns.injectionHostUExpression().sourcePsiFilter(psi -> PsiUtil.isPluginProject(psi.getProject()))).andOr(new ElementPattern[]{UastPatterns.uExpression().constructorParameter(0, Notification.class.getName()), UastPatterns.uExpression().constructorParameter(0, NotificationBuilder.class.getName()), UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("getNotificationGroup")).definedInClass(NotificationGroupManager.class.getName())), UastPatterns.uExpression().constructorParameter(0, SingletonNotificationManager.class.getName())}), (UastReferenceProvider)new UastInjectionHostReferenceProvider(){

            public PsiReference @NotNull [] getReferencesForInjectionHost(@NotNull UExpression uExpression, @NotNull PsiLanguageInjectionHost host, @NotNull ProcessingContext context) {
                return new PsiReference[]{new NotificationGroupIdReference((PsiElement)host)};
            }
        }, (double)0.0);
    }

    private static class NotificationGroupIdReference
    extends ExtensionReferenceBase {
        private NotificationGroupIdReference(PsiElement element) {
            super(element);
        }

        @Override
        protected String getExtensionPointFqn() {
            return "com.intellij.notificationGroup";
        }

        @InspectionMessage
        @NotNull
        public String getUnresolvedMessagePattern() {
            return DevKitBundle.message("code.convert.notification.group.cannot.resolve", this.getValue());
        }

        public Object @NotNull [] getVariants() {
            List<LookupElement> variants = Collections.synchronizedList(new SmartList());
            this.processCandidates((Processor<? super Extension>)((Processor)extension -> {
                GenericAttributeValue<String> id = extension.getId();
                if (id == null || extension.getXmlElement() == null) {
                    return true;
                }
                String value = id.getStringValue();
                if (value == null) {
                    return true;
                }
                String toolwindowId = NotificationGroupIdReference.getAttributeValue(extension, "toolWindowId");
                String displayType = NotificationGroupIdReference.getAttributeValue(extension, "displayType");
                String logByDefault = NotificationGroupIdReference.getAttributeValue(extension, "isLogByDefault");
                Icon logIcon = !"false".equals(logByDefault) ? AllIcons.Ide.Notification.NoEvents : null;
                variants.add((LookupElement)LookupElementBuilder.create((Object)extension.getXmlElement(), (String)value).withTailText((String)(toolwindowId != null ? " (" + toolwindowId + ")" : "")).withTypeText(displayType, logIcon, false).withTypeIconRightAligned(true));
                return true;
            }));
            return variants.toArray(LookupElement.EMPTY_ARRAY);
        }
    }
}

