/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.references.IconsReferencesQueryExecutor;
import org.jetbrains.idea.devkit.util.PsiUtil;

public final class IconsXmlReferencesContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        IconsXmlReferencesContributor.registerForIconXmlAttribute(registrar);
    }

    private static void registerForIconXmlAttribute(@NotNull PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue().withLocalName(new String[]{"icon"}), new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (!PsiUtil.isPluginXmlPsiElement(element)) {
                    return PsiReference.EMPTY_ARRAY;
                }
                return new PsiReference[]{new IconsReferencesQueryExecutor.IconPsiReferenceBase(element){

                    public PsiElement resolve() {
                        String value = ((XmlAttributeValue)element).getValue();
                        if (value.startsWith("/")) {
                            FileReference lastRef = new FileReferenceSet(element).getLastReference();
                            return lastRef != null ? lastRef.resolve() : null;
                        }
                        return IconsReferencesQueryExecutor.resolveIconPath(value, element);
                    }

                    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                        PsiElement element2 = this.resolve();
                        PsiElement resultForFile = this.handleFile(element2, lastRef -> lastRef.handleElementRename(newElementName));
                        if (resultForFile != null) {
                            return resultForFile;
                        }
                        PsiElement resultForField = this.handleField(element2, newElementName);
                        if (resultForField != null) {
                            return resultForField;
                        }
                        return super.handleElementRename(newElementName);
                    }

                    public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
                        PsiElement resultForFile = this.handleFile(element2, lastRef -> lastRef.bindToElement(element2));
                        if (resultForFile != null) {
                            return resultForFile;
                        }
                        PsiElement resultForField = this.handleField(element2, null);
                        if (resultForField != null) {
                            return resultForField;
                        }
                        return super.bindToElement(element2);
                    }

                    private PsiElement handleFile(PsiElement element2, Function<FileReference, PsiElement> callback) {
                        FileReference lastRef;
                        if (element2 instanceof PsiFile && (lastRef = new FileReferenceSet(element2).getLastReference()) != null) {
                            return callback.apply(lastRef);
                        }
                        return null;
                    }

                    @Nullable
                    private PsiElement handleField(PsiElement element2, @Nullable String newElementName) {
                        String classQualifiedName;
                        PsiClass containingClass;
                        if (element2 instanceof PsiField && (containingClass = ((PsiField)element2).getContainingClass()) != null && (classQualifiedName = containingClass.getQualifiedName()) != null) {
                            if (newElementName == null) {
                                newElementName = ((PsiField)element2).getName();
                            }
                            if (classQualifiedName.startsWith("com.intellij.icons.")) {
                                return this.replace(classQualifiedName, newElementName, "com.intellij.icons.");
                            }
                            if (classQualifiedName.startsWith("icons.")) {
                                return this.replace(classQualifiedName, newElementName, "icons.");
                            }
                            return ElementManipulators.handleContentChange((PsiElement)this.myElement, (String)(classQualifiedName + "." + newElementName));
                        }
                        return null;
                    }

                    private PsiElement replace(@NonNls String fqn, @NonNls String newName, @NonNls String pckg) {
                        XmlAttribute parent = (XmlAttribute)this.getElement().getParent();
                        parent.setValue(fqn.substring(pckg.length()) + "." + newName);
                        return parent.getValueElement();
                    }
                }};
            }
        });
    }
}

