/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.UastReferenceProvider;
import com.intellij.psi.UastReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.references.IconsReferencesQueryExecutor;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastUtils;

public final class IconsUastReferencesContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        IconsUastReferencesContributor.registerForPresentationAnnotation(registrar);
        IconsUastReferencesContributor.registerForIconLoaderMethods(registrar);
    }

    private static void registerForIconLoaderMethods(@NotNull PsiReferenceRegistrar registrar) {
        PsiMethodPattern method = ((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("load")).definedInClass("com.intellij.icons.AllIcons");
        PsiJavaElementPattern.Capture findGetIconPattern = (PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().and((ElementPattern)PsiJavaPatterns.psiExpression().methodCallParameter(0, (ElementPattern)method));
        registrar.registerReferenceProvider((ElementPattern)findGetIconPattern, new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (!PsiUtil.isIdeaProject(element.getProject())) {
                    return PsiReference.EMPTY_ARRAY;
                }
                return new FileReferenceSet(element){

                    protected Collection<PsiFileSystemItem> getExtraContexts() {
                        Module iconsModule = ModuleManager.getInstance((Project)element.getProject()).findModuleByName("intellij.platform.icons");
                        if (iconsModule == null) {
                            iconsModule = ModuleManager.getInstance((Project)element.getProject()).findModuleByName("icons");
                        }
                        if (iconsModule == null) {
                            return super.getExtraContexts();
                        }
                        SmartList result = new SmartList();
                        VirtualFile[] roots = ModuleRootManager.getInstance((Module)iconsModule).getSourceRoots();
                        PsiManager psiManager = element.getManager();
                        for (VirtualFile root : roots) {
                            PsiDirectory directory = psiManager.findDirectory(root);
                            ContainerUtil.addIfNotNull((Collection)result, (Object)directory);
                        }
                        return result;
                    }
                }.getAllReferences();
            }
        }, 100.0);
    }

    private static void registerForPresentationAnnotation(@NotNull PsiReferenceRegistrar registrar) {
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, (ElementPattern)((UExpressionPattern)UastPatterns.injectionHostUExpression().sourcePsiFilter(psi -> PsiUtil.isPluginProject(psi.getProject()))).annotationParam(Presentation.class.getName(), "icon"), (UastReferenceProvider)UastReferenceRegistrar.uastInjectionHostReferenceProvider((uElement, referencePsiElement) -> new PsiReference[]{new IconsReferencesQueryExecutor.IconPsiReferenceBase((PsiElement)referencePsiElement, (UExpression)uElement, (PsiLanguageInjectionHost)referencePsiElement){
            final /* synthetic */ UExpression val$uElement;
            final /* synthetic */ PsiLanguageInjectionHost val$referencePsiElement;
            {
                this.val$uElement = uExpression;
                this.val$referencePsiElement = psiLanguageInjectionHost;
                super(element);
            }

            public PsiElement resolve() {
                String value = UastUtils.evaluateString((UExpression)this.val$uElement);
                return IconsReferencesQueryExecutor.resolveIconPath(value, (PsiElement)this.val$referencePsiElement);
            }

            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                PsiElement field = this.resolve();
                PsiElement result = this.handleElement(field, newElementName);
                if (result != null) {
                    return result;
                }
                return super.handleElementRename(newElementName);
            }

            @Nullable
            private PsiElement handleElement(PsiElement element, @Nullable String newElementName) {
                String classQualifiedName;
                PsiClass containingClass;
                if (element instanceof PsiField && (containingClass = ((PsiField)element).getContainingClass()) != null && (classQualifiedName = containingClass.getQualifiedName()) != null) {
                    if (newElementName == null) {
                        newElementName = ((PsiField)element).getName();
                    }
                    if (classQualifiedName.startsWith("com.intellij.icons.")) {
                        return this.replace(newElementName, classQualifiedName, "com.intellij.icons.");
                    }
                    if (classQualifiedName.startsWith("icons.")) {
                        return this.replace(newElementName, classQualifiedName, "icons.");
                    }
                    return ElementManipulators.handleContentChange((PsiElement)this.myElement, (String)(classQualifiedName + "." + newElementName));
                }
                return null;
            }

            private PsiElement replace(@NonNls String newElementName, @NonNls String fqn, @NonNls String packageName) {
                String newValue = fqn.substring(packageName.length()) + "." + newElementName;
                return ElementManipulators.handleContentChange((PsiElement)this.getElement(), (String)newValue);
            }
        }}), (double)100.0);
    }
}

