/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiClassPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.UastInjectionHostReferenceProvider;
import com.intellij.psi.UastReferenceProvider;
import com.intellij.psi.UastReferenceRegistrar;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.index.ExtensionPointIndex;
import org.jetbrains.idea.devkit.references.PluginConfigReference;
import org.jetbrains.idea.devkit.util.PluginRelatedLocatorsUtils;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.uast.UExpression;

public class ExtensionPointDeclarationReferencesContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        PsiClassPattern keyedExtensionCollectorInheritor = PsiJavaPatterns.psiClass().inheritorOf(false, KeyedExtensionCollector.class.getName());
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, (ElementPattern)((UExpressionPattern)UastPatterns.injectionHostUExpression().sourcePsiFilter(psi -> PsiUtil.isPluginProject(psi.getProject()))).andOr(new ElementPattern[]{UastPatterns.uExpression().callParameter(0, (ElementPattern)UastPatterns.callExpression().constructor((ElementPattern)PsiJavaPatterns.psiClass().inheritorOf(true, BaseExtensionPointName.class.getName()))), UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("create")).withParameterCount(1).definedInClass(ExtensionPointName.class.getName())), UastPatterns.uExpression().callParameter(0, (ElementPattern)UastPatterns.callExpression().constructor((ElementPattern)keyedExtensionCollectorInheritor)), UastPatterns.uExpression().callParameter(0, (ElementPattern)UastPatterns.callExpression().withMethodName("super").withResolvedMethod((ElementPattern)PsiJavaPatterns.psiMethod().constructor(true).definedInClass((ElementPattern)keyedExtensionCollectorInheritor), false))}), (UastReferenceProvider)new UastInjectionHostReferenceProvider(){

            public PsiReference @NotNull [] getReferencesForInjectionHost(@NotNull UExpression uExpression, @NotNull PsiLanguageInjectionHost host, @NotNull ProcessingContext context) {
                return new PsiReference[]{new ExtensionPointDeclarationReference((PsiElement)host)};
            }
        }, (double)0.0);
    }

    private static class ExtensionPointDeclarationReference
    extends PsiReferenceBase<PsiElement>
    implements PluginConfigReference {
        private ExtensionPointDeclarationReference(PsiElement psiElement) {
            super(psiElement, PsiUtil.isIdeaProject(psiElement.getProject()));
        }

        public boolean isHighlightedWhenSoft() {
            return true;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            return DevKitBundle.message("code.convert.extension.point.declaration", this.getValue());
        }

        @Nullable
        public PsiElement resolve() {
            Project project = this.getElement().getProject();
            GlobalSearchScope searchScope = PsiManager.getInstance((Project)project).isInProject(this.getElement()) ? GlobalSearchScopesCore.projectProductionScope((Project)project) : PluginRelatedLocatorsUtils.getCandidatesScope(project);
            ExtensionPoint resolved = ExtensionPointIndex.findExtensionPoint(project, searchScope, this.getValue());
            return resolved != null ? resolved.getXmlTag() : null;
        }

        public Object @NotNull [] getVariants() {
            Project project = this.getElement().getProject();
            List<ExtensionPoint> candidates = ExtensionPointIndex.getExtensionPointCandidates(project, GlobalSearchScopesCore.projectProductionScope((Project)project));
            Module currentModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
            ArrayList<Object> lookupElements = new ArrayList<Object>();
            for (ExtensionPoint candidate : candidates) {
                Module module = candidate.getModule();
                assert (module != null);
                LookupElementBuilder builder2 = LookupElementBuilder.create((Object)candidate.getXmlTag(), (String)candidate.getEffectiveQualifiedName()).withTailText(" (" + candidate.getXmlTag().getContainingFile().getName() + ")").withTypeText(module.getName(), ModuleType.get((Module)module).getIcon(), false).withTypeIconRightAligned(true);
                if (module == currentModule) {
                    lookupElements.add(PrioritizedLookupElement.withPriority((LookupElement)builder2.bold(), (double)30.0));
                    continue;
                }
                lookupElements.add(builder2);
            }
            return lookupElements.toArray();
        }
    }
}

